/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow;

import de.uka.ipd.sdq.workflow.AbstractCompositeJob;
import de.uka.ipd.sdq.workflow.CallableJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IProgressMonitor;

public class ParallelCompositeJob
extends AbstractCompositeJob {
    int threadPoolSize = -1;
    private ExecutorService executorService;
    private ExecutorCompletionService<Throwable> executorCompletionService;
    private HashMap<Future<Throwable>, CallableJob> futures = new HashMap();

    public ParallelCompositeJob() {
        this(-1);
    }

    public ParallelCompositeJob(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        this.setupExecutor();
    }

    @Override
    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        for (IJob job : this.myJobs) {
            CallableJob task = new CallableJob(job, monitor);
            Future<Throwable> future = this.executorCompletionService.submit(task);
            this.futures.put(future, task);
        }
        boolean singleJobFailed = false;
        while (this.futures.size() > 0 && !singleJobFailed && !monitor.isCanceled()) {
            try {
                Future<Throwable> completedTask = this.executorCompletionService.take();
                Throwable result = completedTask.get();
                if (result != null) {
                    singleJobFailed = true;
                    continue;
                }
                this.futures.remove(completedTask);
                this.myExecutedJobs.add(this.futures.get(completedTask).getJob());
            }
            catch (InterruptedException e) {
                throw new JobFailedException("Failed waiting for job to finish", e);
            }
            catch (ExecutionException e) {
                throw new JobFailedException("Failed waiting for job to finish", e);
            }
        }
        if (singleJobFailed) {
            throw new JobFailedException("A parallel child job failed");
        }
        if (monitor.isCanceled()) {
            throw new UserCanceledException();
        }
    }

    private void setupExecutor() {
        this.executorService = this.threadPoolSize < 0 ? Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()) : Executors.newFixedThreadPool(this.threadPoolSize);
        this.executorCompletionService = new ExecutorCompletionService(this.executorService);
    }
}

