/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.tests;

import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingCompositeJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mocks.CancelingJob;
import de.uka.ipd.sdq.workflow.mocks.FailingJob;
import de.uka.ipd.sdq.workflow.mocks.MockJob;
import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class OrderPreservingCompositeJobTests
extends TestCase {
    private OrderPreservingCompositeJob myCompJob = null;

    protected void setUp() {
        this.myCompJob = new OrderPreservingCompositeJob();
        MockJob.resetExecutionNumber();
    }

    public void testJobHandling() throws JobFailedException, UserCanceledException, RollbackFailedException {
        MockJob job = new MockJob();
        this.myCompJob.addJob((IJob)job);
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.myCompJob.execute((IProgressMonitor)monitor);
        OrderPreservingCompositeJobTests.assertEquals((boolean)true, (boolean)job.wasExecuted());
        this.myCompJob.rollback((IProgressMonitor)monitor);
        OrderPreservingCompositeJobTests.assertEquals((boolean)true, (boolean)job.wasRolledBack());
    }

    public void testInOrderExecution() throws JobFailedException, UserCanceledException {
        LinkedList<MockJob> jobs = new LinkedList<MockJob>();
        NullProgressMonitor monitor = new NullProgressMonitor();
        int i = 0;
        while (i < 20) {
            jobs.addLast(new MockJob());
            this.myCompJob.addJob((IJob)jobs.peekLast());
            ++i;
        }
        this.myCompJob.execute((IProgressMonitor)monitor);
        int executionNumber = 0;
        while (!jobs.isEmpty()) {
            MockJob job = (MockJob)jobs.removeFirst();
            OrderPreservingCompositeJobTests.assertTrue((String)"Job was executed in the wrong order!", (job.getExecutionNumber() > executionNumber ? 1 : 0) != 0);
            executionNumber = job.getExecutionNumber();
        }
    }

    public void testFailedJob() throws JobFailedException, UserCanceledException {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            this.myCompJob.addJob((IJob)new FailingJob());
            this.myCompJob.execute((IProgressMonitor)monitor);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof JobFailedException));
            return;
        }
        Assert.fail((String)"Expected exception not thrown");
    }

    public void testCanceledJob() throws JobFailedException, UserCanceledException {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            this.myCompJob.addJob((IJob)new CancelingJob());
            this.myCompJob.execute((IProgressMonitor)monitor);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof UserCanceledException));
            return;
        }
        Assert.fail((String)"Expected exception not thrown");
    }
}

