/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.internal;

import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.AbstractQVTREngine;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.QVTREngineFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;

public final class QVTREngines {
    private static final String TAG_ENGINE = "engine";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_CLASS = "factory";
    private final IConfigurationElement configElement;
    private final String id;
    private final String name;
    private QVTREngineFactory factory;
    private static QVTREngines[] cachedEngines;
    private static Logger logger;
    private static Map<String, QVTREngines> enginesMap;

    static {
        logger = Logger.getLogger(QVTREngines.class);
        enginesMap = null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public AbstractQVTREngine newQVTREngine() {
        QVTREngineFactory engineFactory = this.getFactory();
        if (engineFactory == null) {
            return null;
        }
        return engineFactory.createEngine();
    }

    private QVTREngineFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        try {
            this.factory = (QVTREngineFactory)this.configElement.createExecutableExtension(ATT_CLASS);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to instantiate factory: " + this.configElement.getAttribute(ATT_CLASS) + " in type: " + this.id + " in plugin: " + this.configElement.getDeclaringExtension().getNamespaceIdentifier()), (Throwable)e);
        }
        return this.factory;
    }

    private void dispose() {
        if (this.factory == null) {
            return;
        }
        this.factory.dispose();
        this.factory = null;
    }

    private QVTREngines(IConfigurationElement configurationElement) {
        this.configElement = configurationElement;
        this.id = QVTREngines.getAttribute(configurationElement, ATT_ID, null);
        this.name = QVTREngines.getAttribute(configurationElement, ATT_NAME, this.id);
        QVTREngines.getAttribute(configurationElement, ATT_CLASS, null);
    }

    private static String getAttribute(IConfigurationElement configElement, String name, String defaultValue) {
        String value = configElement.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException("missing " + name + " attribute");
    }

    public static QVTREngines[] getAllEngines() {
        if (cachedEngines != null) {
            return cachedEngines;
        }
        try {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("de.uka.ipd.sdq.workflow.mdsd", "qvtrengine").getExtensions();
            ArrayList<QVTREngines> found = new ArrayList<QVTREngines>();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    QVTREngines proxy = QVTREngines.parseEngineConfiguration(configElements[j]);
                    if (proxy != null) {
                        found.add(proxy);
                    }
                    ++j;
                }
                ++i;
            }
            cachedEngines = found.toArray(new QVTREngines[found.size()]);
        }
        catch (InvalidRegistryObjectException e) {
            logger.error((Object)e);
        }
        return cachedEngines;
    }

    private static QVTREngines parseEngineConfiguration(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_ENGINE)) {
            return null;
        }
        try {
            return new QVTREngines(configElement);
        }
        catch (Exception e) {
            String name = configElement.getAttribute(ATT_NAME);
            if (name == null) {
                name = "[missing name attribute]";
            }
            String msg = "Failed to load QVTREngine named " + name + " in " + configElement.getDeclaringExtension().getNamespaceIdentifier();
            logger.error((Object)msg, (Throwable)e);
            return null;
        }
    }

    public static QVTREngines getType(String id) {
        if (enginesMap == null) {
            if (cachedEngines == null) {
                QVTREngines.getAllEngines();
            }
            enginesMap = new HashMap<String, QVTREngines>(cachedEngines.length);
            int i = 0;
            while (i < cachedEngines.length) {
                QVTREngines eachType = cachedEngines[i];
                enginesMap.put(eachType.getId(), eachType);
                ++i;
            }
        }
        return enginesMap.get(id);
    }

    public static void disposeEngines() {
        if (cachedEngines == null) {
            return;
        }
        int i = 0;
        while (i < cachedEngines.length) {
            cachedEngines[i].dispose();
            ++i;
        }
        cachedEngines = null;
    }
}

