/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.launchconfig.tabs;

import de.uka.ipd.sdq.workflow.launchconfig.ConstantsContainer;
import de.uka.ipd.sdq.workflow.launchconfig.RunConfigImages;
import de.uka.ipd.sdq.workflow.launchconfig.RunConfigPlugin;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;

public class FileNamesInputTab
extends AbstractLaunchConfigurationTab {
    protected static final String PCM_GLASSFISHREPOSITORY_FILE_URI = "pathmap://PCM_MODELS/Glassfish.repository";
    protected Text textAllocation;
    protected Text textUsage;
    protected Text mwtextRepository;
    protected Composite container;

    public Image getImage() {
        return RunConfigImages.getFileNamesTabImage();
    }

    protected void setOpenFileDialogResultToTextField(Text textField, String[] EXTENSION) {
        String resultOpenFileDialog = this.openFileDialog(EXTENSION);
        if (!resultOpenFileDialog.equals(new String(""))) {
            textField.setText(resultOpenFileDialog);
        }
    }

    protected void setOpenFileDialogResultToTextField(Text textField, String EXTENSION) {
        String resultOpenFileDialog = this.openResourceDialog(EXTENSION);
        if (!resultOpenFileDialog.equals(new String(""))) {
            textField.setText(resultOpenFileDialog);
        }
    }

    public void createControl(Composite parent) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileNamesInputTab.this.setDirty(true);
                FileNamesInputTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.container = new Composite(parent, 0);
        this.setControl((Control)this.container);
        this.container.setLayout((Layout)new GridLayout());
        this.mwtextRepository = new Text(this.container, 2052);
        this.createFileInputSection(this.container, modifyListener, "Middleware Repository File", ConstantsContainer.REPOSITORY_EXTENSION, this.mwtextRepository);
        this.textAllocation = new Text(this.container, 2052);
        this.createFileInputSection(this.container, modifyListener, "Allocation File", ConstantsContainer.ALLOCATION_EXTENSION, this.textAllocation);
        this.textUsage = new Text(this.container, 2052);
        this.createFileInputSection(this.container, modifyListener, "Usage File", ConstantsContainer.USAGEMODEL_EXTENSION, this.textUsage);
    }

    public void createFileInputSection(Composite container, ModifyListener modifyListener, String modelFileLabel, String[] fileExtension, Text textFileNameToLoad) {
        Group fileInputGroup = new Group(container, 0);
        GridLayout glFileInputGroup = new GridLayout();
        glFileInputGroup.numColumns = 3;
        fileInputGroup.setLayout((Layout)glFileInputGroup);
        fileInputGroup.setText(modelFileLabel);
        fileInputGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        textFileNameToLoad.setParent((Composite)fileInputGroup);
        GridData gd_textFileName = new GridData(4, 0x1000000, true, false);
        gd_textFileName.widthHint = 200;
        textFileNameToLoad.setLayoutData((Object)gd_textFileName);
        textFileNameToLoad.addModifyListener(modifyListener);
        Button workspaceButton_4 = new Button((Composite)fileInputGroup, 0);
        workspaceButton_4.setText("Workspace...");
        workspaceButton_4.addSelectionListener((SelectionListener)new WorkspaceButtonSelectionListener(textFileNameToLoad, fileExtension));
        Button buttonUsage = new Button((Composite)fileInputGroup, 0);
        buttonUsage.setText("File System...");
        buttonUsage.addSelectionListener((SelectionListener)new FileSystemButtonSelectionAdapter(textFileNameToLoad, fileExtension));
    }

    public String getName() {
        return "Models file";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.textAllocation.setText(configuration.getAttribute("allocationFile", ""));
        }
        catch (CoreException e) {
            RunConfigPlugin.errorLogger(this.getName(), "Allocation File", e.getMessage());
        }
        try {
            this.mwtextRepository.setText(configuration.getAttribute("mwRepositoryFile", ""));
        }
        catch (CoreException e) {
            RunConfigPlugin.errorLogger(this.getName(), "Middleware Repository File", e.getMessage());
        }
        try {
            this.textUsage.setText(configuration.getAttribute("usageFile", ""));
        }
        catch (CoreException e) {
            RunConfigPlugin.errorLogger(this.getName(), "Usage File", e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("mwRepositoryFile", this.mwtextRepository.getText());
        configuration.setAttribute("allocationFile", this.textAllocation.getText());
        configuration.setAttribute("usageFile", this.textUsage.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("mwRepositoryFile", PCM_GLASSFISHREPOSITORY_FILE_URI);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (!this.validateFilePath(this.mwtextRepository.getText(), ConstantsContainer.REPOSITORY_EXTENSION)) {
            this.setErrorMessage("Middleware Repository is missing!");
            return false;
        }
        if (!this.validateFilePath(this.textAllocation.getText(), ConstantsContainer.ALLOCATION_EXTENSION)) {
            this.setErrorMessage("Allocation is missing!");
            return false;
        }
        if (!this.validateFilePath(this.textUsage.getText(), ConstantsContainer.USAGEMODEL_EXTENSION)) {
            this.setErrorMessage("Usage is missing!");
            return false;
        }
        return true;
    }

    public boolean canSave() {
        return true;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    protected boolean validateFilePath(String filePath, String[] extensions) {
        if (filePath.equals("")) {
            return false;
        }
        String extension = this.getExtensionFromArray(extensions).replace("*", "");
        return filePath.contains(extension);
    }

    protected String getExtensionFromArray(String[] array) {
        return array[0];
    }

    protected String openFileDialog(String[] extensions) {
        String filename = "";
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(extensions);
        dialog.setText("Select model file");
        if (dialog.open() != null) {
            String root = String.valueOf(dialog.getFilterPath()) + File.separatorChar;
            filename = String.valueOf(root) + dialog.getFileName();
        }
        return filename;
    }

    protected String openResourceDialog(String extension) {
        ArrayList<ResourcePatternFilter> filters = new ArrayList<ResourcePatternFilter>();
        ResourcePatternFilter filter = new ResourcePatternFilter();
        filter.setPatterns(new String[]{"*diagram", "*.settings", "*.project"});
        filters.add(filter);
        String msg = "Select a file (" + extension + ").";
        IFile file = null;
        IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)this.getShell(), null, (String)msg, (boolean)false, null, filters);
        if (files.length != 0) {
            file = files[0];
        }
        if (file != null) {
            return file.getLocation().toOSString();
        }
        return "";
    }

    public String getId() {
        return "de.uka.ipd.sdq.codegen.runconfig.tabs.FileNamesInputTab";
    }

    class FileSystemButtonSelectionAdapter
    extends SelectionAdapter {
        private Text field;
        private String[] extensions;

        public FileSystemButtonSelectionAdapter(Text field, String[] fileExtension) {
            this.field = field;
            this.extensions = fileExtension;
        }

        public void widgetSelected(SelectionEvent e) {
            FileNamesInputTab.this.setOpenFileDialogResultToTextField(this.field, this.extensions);
        }
    }

    class WorkspaceButtonSelectionListener
    extends SelectionAdapter {
        private Text field;
        private String extension;

        public WorkspaceButtonSelectionListener(Text field, String[] extensions) {
            this.field = field;
            this.extension = FileNamesInputTab.this.getExtensionFromArray(extensions);
        }

        public void widgetSelected(SelectionEvent e) {
            FileNamesInputTab.this.setOpenFileDialogResultToTextField(this.field, this.extension);
        }
    }
}

