/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.statistics.test;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.dao.IExperimentDAO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class TestUtils {
    public static List<Double> createSampleSequence(int numberOfSamples, int desiredLag) {
        Random random = new Random();
        ArrayList<Double> samples = new ArrayList<Double>();
        int i = 0;
        while (i < numberOfSamples) {
            double randDbl = random.nextDouble();
            int j = 0;
            while (j < desiredLag && i + j < numberOfSamples) {
                samples.add(randDbl + (double)j * randDbl);
                ++j;
            }
            i += desiredLag;
        }
        return samples;
    }

    public static Collection<Measurement> loadMeasurements(IDAOFactory factory, String experimentName, int runId, int sensorId) {
        IExperimentDAO experimentDAO = factory.createExperimentDAO();
        Collection experiment = experimentDAO.findByExperimentName(experimentName);
        Iterator iterator = experiment.iterator();
        if (iterator.hasNext()) {
            Experiment experiment2 = (Experiment)iterator.next();
            return TestUtils.loadMeasurementsFromExperiment(experiment2, runId, sensorId);
        }
        throw new RuntimeException("No Experiment with name " + experimentName + " available.");
    }

    private static Collection<Measurement> loadMeasurementsFromExperiment(Experiment experiment, int runId, int sensorId) {
        TimeSpanSensor sensor = null;
        for (Sensor s : experiment.getSensors()) {
            if (s.getSensorID() != (long)sensorId || !(s instanceof TimeSpanSensor)) continue;
            sensor = (TimeSpanSensor)s;
            break;
        }
        ExperimentRun run = null;
        for (ExperimentRun r : experiment.getExperimentRuns()) {
            if (r.getExperimentRunID() != (long)runId) continue;
            run = r;
            break;
        }
        SensorAndMeasurements sam = run.getMeasurementsOfSensor(sensor);
        return sam.getMeasurements();
    }

    public static Collection<Measurement> loadMeasurements(IDAOFactory factory, int experimentId, int runId, int sensorId) {
        IExperimentDAO experimentDAO = factory.createExperimentDAO();
        Experiment experiment = null;
        for (Experiment e : experimentDAO.getExperiments()) {
            System.out.println(e.getExperimentName());
            if (e.getExperimentID() != (long)experimentId) continue;
            experiment = e;
            break;
        }
        return TestUtils.loadMeasurementsFromExperiment(experiment, runId, sensorId);
    }
}

