/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.statistics.test;

import de.uka.ipd.sdq.statistics.IBatchAlgorithm;
import de.uka.ipd.sdq.statistics.PhiMixingBatchAlgorithm;
import de.uka.ipd.sdq.statistics.estimation.SampleMeanEstimator;
import de.uka.ipd.sdq.statistics.test.TestUtils;
import java.util.List;
import junit.framework.TestCase;

public class TestPhiMixingBatchAlgorithm
extends TestCase {
    private IBatchAlgorithm batchAlgorithm;

    protected void setUp() throws Exception {
        super.setUp();
        this.batchAlgorithm = new PhiMixingBatchAlgorithm();
    }

    public void testPhiMixing() {
        List<Double> samples = TestUtils.createSampleSequence(32000, 4);
        this.batchAlgorithm.offerSamples(samples);
        double expectedMean = new SampleMeanEstimator().estimatePoint(samples);
        double actualMean = new SampleMeanEstimator().estimatePoint(this.batchAlgorithm.getBatchMeans());
        TestPhiMixingBatchAlgorithm.assertTrue((boolean)this.batchAlgorithm.hasValidBatches());
        TestPhiMixingBatchAlgorithm.assertEquals((double)expectedMean, (double)actualMean, (double)0.01);
    }
}

