/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.statistics.test;

import de.uka.ipd.sdq.sensorframework.dao.file.FileDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.statistics.CrossingMeanWarmUpFilter;
import de.uka.ipd.sdq.statistics.test.TestUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;

public class TestCrossingMeanWarmUpFilter
extends TestCase {
    public void testWarmUpFilter() {
        String dataStorePath = "D:\\Studium\\Master\\HiWi IPD\\runtime-150909\\brs\\Data4";
        File dataStoreFolder = new File(dataStorePath);
        if (dataStoreFolder.exists()) {
            FileDAOFactory factory = new FileDAOFactory(dataStorePath);
            Collection<Measurement> measurements = TestUtils.loadMeasurements((IDAOFactory)factory, 0, 0, 24);
            ArrayList<Double> samples = new ArrayList<Double>(measurements.size());
            for (Measurement m : measurements) {
                TimeSpanMeasurement tsm = (TimeSpanMeasurement)m;
                samples.add(tsm.getTimeSpan());
            }
            CrossingMeanWarmUpFilter filter = new CrossingMeanWarmUpFilter();
            int i = 0;
            for (Double sample : samples) {
                filter.offerSample(sample);
                if (filter.isStationary()) {
                    System.out.println("Warm-Up Peroid: Up to measurement " + i);
                    break;
                }
                ++i;
            }
            factory.finalizeAndClose();
        } else {
            System.err.println("Could not find data store path \"" + dataStorePath + "\"");
        }
    }
}

