/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.statistics.independence.test;

import de.uka.ipd.sdq.statistics.independence.IIndependenceTest;
import de.uka.ipd.sdq.statistics.independence.RunUpTest;
import de.uka.ipd.sdq.statistics.test.TestUtils;
import java.util.List;
import junit.framework.TestCase;

public class TestRunUpTest
extends TestCase {
    private IIndependenceTest indTest;

    protected void setUp() throws Exception {
        super.setUp();
        this.indTest = new RunUpTest();
    }

    public void testDependence() {
        int desiredLag = 2;
        int numberOfSamples = this.indTest.getLowerSampleLimit();
        int repititions = 100;
        List<Double> samples = null;
        int indepCnt = 0;
        int depCnt = 0;
        int i = 0;
        while (i < repititions) {
            samples = TestUtils.createSampleSequence(numberOfSamples, desiredLag);
            if (this.indTest.testIndependence(samples)) {
                ++indepCnt;
            } else {
                ++depCnt;
            }
            ++i;
        }
        System.out.println("Dependent: " + depCnt + ", Independent: " + indepCnt);
        TestRunUpTest.assertTrue((depCnt > indepCnt ? 1 : 0) != 0);
    }

    public void testIndependence() {
        int desiredLag = 1;
        int numberOfSamples = this.indTest.getLowerSampleLimit();
        int repititions = 100;
        List<Double> samples = null;
        int indepCnt = 0;
        int depCnt = 0;
        int i = 0;
        while (i < repititions) {
            samples = TestUtils.createSampleSequence(numberOfSamples, desiredLag);
            if (this.indTest.testIndependence(samples)) {
                ++indepCnt;
            } else {
                ++depCnt;
            }
            ++i;
        }
        System.out.println("Dependent: " + depCnt + ", Independent: " + indepCnt);
        TestRunUpTest.assertTrue((depCnt < indepCnt ? 1 : 0) != 0);
    }
}

