/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.usage;

import de.uka.ipd.sdq.probespec.framework.ProbeSpecContext;
import de.uka.ipd.sdq.probespec.framework.RequestContext;
import de.uka.ipd.sdq.probespec.framework.garbagecollection.IRegionBasedGarbageCollector;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.SimProcess;
import de.uka.ipd.sdq.simucomframework.exceptions.FailureException;
import de.uka.ipd.sdq.simucomframework.exceptions.FailureStatistics;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.usage.IScenarioRunner;
import de.uka.ipd.sdq.simucomframework.usage.IUser;

public class OpenWorkloadUser
extends SimProcess
implements IUser {
    private IScenarioRunner scenarioRunner;
    private IRegionBasedGarbageCollector<RequestContext> blackboardGarbageCollector;

    public OpenWorkloadUser(SimuComModel owner, String name, IScenarioRunner scenarioRunner) {
        super(owner, name);
        this.scenarioRunner = scenarioRunner;
        this.blackboardGarbageCollector = ProbeSpecContext.instance().getBlackboardGarbageCollector();
    }

    @Override
    protected void internalLifeCycle() {
        block6: {
            logger.debug((Object)(String.valueOf(this.getName()) + " started! I'm alive!!!"));
            this.updateNewSessionID();
            try {
                try {
                    this.blackboardGarbageCollector.enterRegion((Object)this.getRequestContext().rootContext());
                    this.scenarioRunner(this);
                }
                catch (FailureException exception) {
                    if (this.getModel().getConfig().getSimulateFailures()) {
                        FailureStatistics.getInstance().increaseUnhandledFailureCounter(exception.getFailureType(), this.currentSessionId);
                    }
                    this.getModel().increaseMainMeasurementsCount();
                    this.blackboardGarbageCollector.leaveRegion((Object)this.getRequestContext().rootContext());
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.getModel().increaseMainMeasurementsCount();
                this.blackboardGarbageCollector.leaveRegion((Object)this.getRequestContext().rootContext());
                throw throwable;
            }
            this.getModel().increaseMainMeasurementsCount();
            this.blackboardGarbageCollector.leaveRegion((Object)this.getRequestContext().rootContext());
        }
        logger.debug((Object)(String.valueOf(this.getName()) + " done! I'm dying!!!"));
    }

    @Override
    public void scenarioRunner(SimProcess thread) {
        this.scenarioRunner.scenarioRunner(thread);
    }

    @Override
    public void startUserLife() {
        this.scheduleAt(0.0);
    }
}

