/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.usage;

import de.uka.ipd.sdq.simucomframework.Context;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.SimProcess;
import de.uka.ipd.sdq.simucomframework.exceptions.FailureStatistics;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.usage.IUser;
import de.uka.ipd.sdq.simucomframework.usage.IUserFactory;
import de.uka.ipd.sdq.simucomframework.usage.IWorkloadDriver;
import org.apache.log4j.Logger;

public class OpenWorkload
extends SimProcess
implements IWorkloadDriver {
    private String interArrivalTime;
    private IUserFactory userFactory;
    private static Logger logger = Logger.getLogger((String)OpenWorkload.class.getName());

    public OpenWorkload(SimuComModel model, IUserFactory userFactory, String interArrivalTime) {
        super(model, "OpenWorkloadUserMaturationChamber");
        this.interArrivalTime = interArrivalTime;
        this.userFactory = userFactory;
    }

    @Override
    public void run() {
        this.scheduleAt(0.0);
    }

    @Override
    protected void internalLifeCycle() {
        FailureStatistics.getInstance().reset();
        while (this.getModel().getSimulationControl().isRunning()) {
            try {
                this.generateUser();
                this.waitForNextUser();
                if (!this.getModel().getConfig().getSimulateFailures()) continue;
                FailureStatistics.getInstance().increaseRunCount();
                FailureStatistics.getInstance().printRunCount(logger);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                logger.info((Object)"Stopping simulation run due to memory constraints.");
                this.getModel().getSimulationControl().stop();
            }
        }
    }

    private void waitForNextUser() {
        double interArrivalTimeSample = (Double)Context.evaluateStatic((String)this.interArrivalTime, Double.class);
        logger.debug((Object)("Waiting for " + interArrivalTimeSample + " before spawing the next user"));
        this.hold(interArrivalTimeSample);
    }

    private IUser generateUser() {
        logger.debug((Object)"Spawning New User...");
        IUser user = this.userFactory.createUser();
        user.startUserLife();
        return user;
    }
}

