/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.usage;

import de.uka.ipd.sdq.probespec.framework.ProbeSpecContext;
import de.uka.ipd.sdq.probespec.framework.RequestContext;
import de.uka.ipd.sdq.probespec.framework.garbagecollection.IRegionBasedGarbageCollector;
import de.uka.ipd.sdq.simucomframework.Context;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.SimProcess;
import de.uka.ipd.sdq.simucomframework.exceptions.FailureException;
import de.uka.ipd.sdq.simucomframework.exceptions.FailureStatistics;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.usage.IScenarioRunner;
import de.uka.ipd.sdq.simucomframework.usage.IUser;
import org.apache.log4j.Logger;

public class ClosedWorkloadUser
extends SimProcess
implements IUser {
    private static Logger logger = Logger.getLogger((String)ClosedWorkloadUser.class.getName());
    private IScenarioRunner scenarioRunner;
    private String thinkTime;
    private int runCount = 0;
    private IRegionBasedGarbageCollector<RequestContext> blackboardGarbageCollector;
    protected long sessionId;

    public ClosedWorkloadUser(SimuComModel owner, String name, IScenarioRunner scenarioRunner2, String thinkTimeSpec) {
        super(owner, name);
        this.scenarioRunner = scenarioRunner2;
        this.thinkTime = thinkTimeSpec;
        this.blackboardGarbageCollector = ProbeSpecContext.instance().getBlackboardGarbageCollector();
    }

    @Override
    protected void internalLifeCycle() {
        while (this.getModel().getSimulationControl().isRunning()) {
            this.updateNewSessionID();
            try {
                try {
                    if (this.getModel().getConfig().getSimulateFailures()) {
                        FailureStatistics.getInstance().increaseRunCount();
                        FailureStatistics.getInstance().printRunCount(logger);
                    }
                    this.blackboardGarbageCollector.enterRegion((Object)this.getRequestContext().rootContext());
                    this.scenarioRunner(this);
                }
                catch (FailureException exception) {
                    if (this.getModel().getConfig().getSimulateFailures()) {
                        FailureStatistics.getInstance().increaseUnhandledFailureCounter(exception.getFailureType(), this.currentSessionId);
                    }
                    this.getModel().increaseMainMeasurementsCount();
                    this.blackboardGarbageCollector.leaveRegion((Object)this.getRequestContext().rootContext());
                    ++this.runCount;
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.getModel().increaseMainMeasurementsCount();
                this.blackboardGarbageCollector.leaveRegion((Object)this.getRequestContext().rootContext());
                ++this.runCount;
                throw throwable;
            }
            this.getModel().increaseMainMeasurementsCount();
            this.blackboardGarbageCollector.leaveRegion((Object)this.getRequestContext().rootContext());
            ++this.runCount;
        }
    }

    @Override
    public void scenarioRunner(SimProcess thread) {
        double thinkTime = (Double)Context.evaluateStatic((String)this.thinkTime, Double.class, null);
        this.hold(thinkTime);
        this.scenarioRunner.scenarioRunner(thread);
    }

    @Override
    public void startUserLife() {
        logger.debug((Object)(String.valueOf(this.getName()) + " started! I'm alive!!!"));
        this.scheduleAt(0.0);
    }

    @Override
    public RequestContext getRequestContext() {
        return super.getRequestContext().append("." + this.runCount);
    }
}

