/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.resources;

import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.scheduler.priority.IPriorityBoost;
import de.uka.ipd.sdq.scheduler.priority.IPriorityUpdateStrategy;
import de.uka.ipd.sdq.scheduler.priority.boost.StaticPriorityBoost;
import de.uka.ipd.sdq.scheduler.priority.update.DecayToBaseUpdate;
import de.uka.ipd.sdq.scheduler.resources.active.SimActiveResource;
import de.uka.ipd.sdq.scheduler.resources.passive.SimFairPassiveResource;
import de.uka.ipd.sdq.scheduler.resources.passive.SimSimpleFairPassiveResource;
import de.uka.ipd.sdq.scheduler.resources.passive.SimUnfairPassiveResource;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.CalculatorHelper;
import de.uka.ipd.sdq.simucomframework.resources.ScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.SchedulingStrategy;

public class SimulatedResourceContainer
extends AbstractSimulatedResourceContainer {
    private SchedulingStrategy operatingSystem;
    private AbstractScheduledResource managingResource = null;

    public SimulatedResourceContainer(SimuComModel myModel, String containerID) {
        super(myModel, containerID);
    }

    public IPassiveResource createPassiveResource(String name, String id, int capacity) {
        IPassiveResource r = null;
        if (this.managingResource == null) {
            r = this.getSimplePassiveResource(name, id, capacity);
        } else {
            switch (this.operatingSystem) {
                case WINDOWS_SERVER_2003: 
                case WINDOWS_7: 
                case WINDOWS_VISTA: 
                case WINDOWS_XP: {
                    r = this.getPassiveResourceWindows(name, id, capacity, 1, true, true, this.managingResource.getScheduledResource());
                    break;
                }
                case LINUX_2_6_O1: 
                case LINUX_2_6_CFS: {
                    r = this.getPassiveResourceLinux(name, id, capacity, true, this.managingResource.getScheduledResource());
                }
            }
        }
        CalculatorHelper.setupStateCalculator(r, this.myModel.getSimulationControl());
        CalculatorHelper.setupWaitingTimeCalculator(r, this.myModel.getSimulationControl());
        CalculatorHelper.setupHoldTimeCalculator(r, this.myModel.getSimulationControl());
        return r;
    }

    public void addActiveResource(String typeID, String description, String processingRate, Double mttf, Double mttr, String units, SchedulingStrategy strategy, int numberOfReplicas) {
        ScheduledResource r = new ScheduledResource(this.myModel, typeID, description, processingRate, mttf, mttr, strategy, numberOfReplicas);
        this.activeResources.put(typeID, r);
        if (strategy == SchedulingStrategy.LINUX_2_6_O1 || strategy == SchedulingStrategy.LINUX_2_6_CFS || strategy == SchedulingStrategy.WINDOWS_SERVER_2003 || strategy == SchedulingStrategy.WINDOWS_XP || strategy == SchedulingStrategy.WINDOWS_VISTA || strategy == SchedulingStrategy.WINDOWS_7) {
            assert (this.managingResource == null);
            this.operatingSystem = strategy;
            this.managingResource = (AbstractScheduledResource)this.activeResources.get(typeID);
        }
        CalculatorHelper.setupDemandCalculator(r);
        CalculatorHelper.setupOverallUtilizationCalculator(r);
        if (strategy != SchedulingStrategy.PROCESSOR_SHARING && strategy != SchedulingStrategy.FCFS) {
            CalculatorHelper.setupStateCalculator(r);
        }
    }

    private IPassiveResource getPassiveResourceWindows(String name, String id, int capacity, int bonus, boolean resetTimeSlice, boolean isFair, IActiveResource managingResource) {
        DecayToBaseUpdate update = new DecayToBaseUpdate();
        StaticPriorityBoost boost = new StaticPriorityBoost((IPriorityUpdateStrategy)update, bonus, 0, resetTimeSlice);
        if (isFair) {
            return new SimFairPassiveResource(capacity, name, id, (IPriorityBoost)boost, (SimActiveResource)managingResource);
        }
        return new SimUnfairPassiveResource(capacity, name, id, (IPriorityBoost)boost, (SimActiveResource)managingResource, 0.1, true);
    }

    private IPassiveResource getPassiveResourceLinux(String name, String id, int capacity, boolean isFair, IActiveResource managingResource) {
        if (isFair) {
            return new SimFairPassiveResource(capacity, name, id, null, (SimActiveResource)managingResource);
        }
        return new SimUnfairPassiveResource(capacity, name, id, null, (SimActiveResource)managingResource, 0.1, true);
    }

    private IPassiveResource getSimplePassiveResource(String name, String id, int capacity) {
        return new SimSimpleFairPassiveResource(capacity, name, id);
    }
}

