/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.resources;

import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.ISchedulingFactory;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.SimProcess;
import de.uka.ipd.sdq.simucomframework.exceptions.EnvironmentFailureException;
import de.uka.ipd.sdq.simucomframework.exceptions.ThroughputZeroOrNegativeException;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.SchedulingStrategy;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import org.apache.log4j.Logger;

public class SimulatedLinkingResource
extends AbstractScheduledResource {
    protected static Logger logger = Logger.getLogger((String)SimulatedLinkingResource.class.getName());
    private String throughput;
    private String latencySpec;
    private static long resourceId = 1L;
    IActiveResource aResource = null;
    private double totalDemandedTime;
    private boolean utilizationSet = false;

    public SimulatedLinkingResource(SimuComModel myModel, String typeID, String description, String d, String latencySpec, Double failureProbability) {
        super(myModel, typeID, description, SchedulingStrategy.FCFS, 1);
        this.latencySpec = latencySpec;
        this.throughput = d;
        this.failureProbability = failureProbability;
        this.canFail = myModel.getConfig().getSimulateFailures() && this.failureProbability > 0.0;
        this.aResource = ISchedulingFactory.eINSTANCE.createSimFCFSResource(SchedulingStrategy.FCFS.toString(), SimulatedLinkingResource.getNextResourceId());
    }

    @Override
    protected double calculateDemand(double demand) {
        double calculatedThroughput = NumberConverter.toDouble((Object)StackContext.evaluateStatic((String)this.throughput));
        if (calculatedThroughput <= 0.0) {
            throw new ThroughputZeroOrNegativeException("Throughput at resource " + this.getName() + " was less or equal zero");
        }
        double result = NumberConverter.toDouble((Object)StackContext.evaluateStatic((String)this.latencySpec)) + demand / calculatedThroughput;
        return result;
    }

    @Override
    public void consumeResource(SimProcess process, double abstractDemand) {
        if (this.canFail && Math.random() < this.failureProbability) {
            EnvironmentFailureException.raise(this.getName());
        }
        double concreteDemand = this.calculateDemand(abstractDemand);
        this.fireDemand(concreteDemand);
        this.totalDemandedTime += concreteDemand;
        this.aResource.process((ISchedulableProcess)process, concreteDemand);
    }

    @Override
    public IActiveResource getScheduledResource() {
        return this.aResource;
    }

    private void registerProcessWindows(ISchedulableProcess process, IActiveResource resource) {
    }

    @Override
    public void activateResource() {
        this.aResource.start();
    }

    @Override
    public void deactivateResource() {
        if (!this.utilizationSet) {
            this.utilizationSet = true;
        }
        this.aResource.stop();
    }

    public static String getNextResourceId() {
        return "NETWORK_" + Long.toString(resourceId++);
    }
}

