/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.resources;

import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.IRunningProcess;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.ISchedulingFactory;
import de.uka.ipd.sdq.scheduler.processes.impl.ProcessWithPriority;
import de.uka.ipd.sdq.scheduler.sensors.IActiveResourceStateSensor;
import de.uka.ipd.sdq.scheduler.tools.SchedulerTools;
import de.uka.ipd.sdq.simucomframework.Context;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.SimProcess;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.SchedulingStrategy;
import scheduler.SchedulerLibrary;
import scheduler.configuration.ActiveResourceConfiguration;
import scheduler.configuration.ConfigurationFactory;
import scheduler.configuration.PriorityClass;
import scheduler.configuration.ProcessConfiguration;
import scheduler.configuration.SchedulerConfiguration;

public class ScheduledResource
extends AbstractScheduledResource
implements IActiveResourceStateSensor {
    private static final String PATHMAP_TO_SCHEDULER_LIBRARY = "pathmap://PCM_MODELS/Library.scheduler";
    private static long resourceId = 1L;
    private String processingRate = "0";
    IActiveResource aResource = null;
    ActiveResourceConfiguration resourceConf = null;
    private double totalDemandedTime;
    private int numberOfCores;

    public ScheduledResource(SimuComModel myModel, String typeID, String description, String processingRate, Double mttf, Double mttr, SchedulingStrategy strategy, int numberOfCores) {
        super(myModel, typeID, description, strategy, numberOfCores);
        this.processingRate = processingRate;
        this.numberOfCores = numberOfCores;
        logger.debug((Object)("Creating scheduled resource with strategy " + strategy.name() + " and " + numberOfCores + " replicas!"));
        this.aResource = this.getScheduledResource(strategy, numberOfCores, "Utilisation of " + typeID + " " + description);
        this.aResource.addObserver((IActiveResourceStateSensor)this);
        this.mttf = mttf;
        this.mttr = mttr;
        boolean bl = this.canBeUnavailable = myModel.getConfig().getSimulateFailures() && this.mttf > 0.0 && this.mttr > 0.0;
        if (this.canBeUnavailable) {
            this.createAvailabilityEvents(myModel);
        }
    }

    private IActiveResource getResource(String schedulerLibFileName, String schedulerName, int numReplicas, String sensorDescription) {
        SchedulerLibrary lib = (SchedulerLibrary)SchedulerTools.loadFromXMI((String)schedulerLibFileName);
        SchedulerConfiguration selectedConf = null;
        for (SchedulerConfiguration conf : lib.getSchedulerConfiguration()) {
            if (!conf.getName().equals(schedulerName)) continue;
            selectedConf = conf;
            break;
        }
        if (selectedConf != null) {
            this.resourceConf = ConfigurationFactory.eINSTANCE.createActiveResourceConfiguration();
            this.resourceConf.setName(schedulerName);
            this.resourceConf.setReplicas(numReplicas);
            this.resourceConf.setSchedulerConfiguration(selectedConf);
            IActiveResource resource = ISchedulingFactory.eINSTANCE.createActiveResource(this.resourceConf);
            return resource;
        }
        return null;
    }

    private IActiveResource getScheduledResource(SchedulingStrategy strategy, int numberOfCores, String sensorDescription) {
        IActiveResource scheduledResource = null;
        switch (strategy) {
            case FCFS: {
                scheduledResource = ISchedulingFactory.eINSTANCE.createSimFCFSResource(SchedulingStrategy.FCFS.toString(), ScheduledResource.getNextResourceId());
                break;
            }
            case PROCESSOR_SHARING: {
                scheduledResource = ISchedulingFactory.eINSTANCE.createSimProcessorSharingResource(SchedulingStrategy.PROCESSOR_SHARING.toString(), ScheduledResource.getNextResourceId(), numberOfCores);
                break;
            }
            case DELAY: {
                scheduledResource = ISchedulingFactory.eINSTANCE.createSimDelayResource(SchedulingStrategy.DELAY.toString(), ScheduledResource.getNextResourceId());
                break;
            }
            case LINUX_2_6_O1: {
                scheduledResource = this.getResource(PATHMAP_TO_SCHEDULER_LIBRARY, "Linux 2.6.22", numberOfCores, sensorDescription);
                break;
            }
            case LINUX_2_6_CFS: {
                scheduledResource = ISchedulingFactory.eINSTANCE.createSimProcessorSharingResource(SchedulingStrategy.LINUX_2_6_CFS.toString(), ScheduledResource.getNextResourceId(), numberOfCores);
                break;
            }
            case WINDOWS_SERVER_2003: 
            case WINDOWS_7: 
            case WINDOWS_VISTA: {
                scheduledResource = this.getResource(PATHMAP_TO_SCHEDULER_LIBRARY, "Windows 2003", numberOfCores, sensorDescription);
                break;
            }
            case WINDOWS_XP: {
                scheduledResource = this.getResource(PATHMAP_TO_SCHEDULER_LIBRARY, "Windows XP", numberOfCores, sensorDescription);
                break;
            }
            case SPECIAL_WINDOWS: {
                scheduledResource = ISchedulingFactory.eINSTANCE.createSimProcessorSharingResourceWindows(SchedulingStrategy.SPECIAL_WINDOWS.toString(), ScheduledResource.getNextResourceId(), numberOfCores);
                break;
            }
            case SPECIAL_LINUXO1: {
                scheduledResource = ISchedulingFactory.eINSTANCE.createSimProcessorSharingResourceLinuxO1(SchedulingStrategy.SPECIAL_LINUXO1.toString(), ScheduledResource.getNextResourceId(), numberOfCores);
            }
        }
        return scheduledResource;
    }

    private void registerProcessWindows(ISchedulableProcess process, IActiveResource resource) {
        if (this.resourceConf != null) {
            ProcessConfiguration processConf = ConfigurationFactory.eINSTANCE.createProcessConfiguration();
            processConf.setName(process.getId());
            processConf.setPriority(PriorityClass.DEFAULT);
            processConf.setReplicas(1);
            ProcessWithPriority p = (ProcessWithPriority)ISchedulingFactory.eINSTANCE.createRunningProcess(process, processConf, this.resourceConf);
            resource.registerProcess((IRunningProcess)p);
        }
    }

    @Override
    protected double calculateDemand(double demand) {
        return demand / (Double)Context.evaluateStatic((String)this.processingRate, Double.class);
    }

    @Override
    public void activateResource() {
        this.aResource.start();
        super.activateResource();
    }

    @Override
    public void consumeResource(SimProcess process, double abstractDemand) {
        this.assertAvailability();
        this.registerProcessWindows(process, this.aResource);
        double concreteDemand = this.calculateDemand(abstractDemand);
        this.fireDemand(concreteDemand);
        this.totalDemandedTime += concreteDemand;
        this.aResource.process((ISchedulableProcess)process, concreteDemand);
    }

    @Override
    public void deactivateResource() {
        double totalTime = this.getModel().getSimulationControl().getCurrentSimulationTime() * (double)this.numberOfCores;
        if (this.totalDemandedTime > totalTime) {
            this.totalDemandedTime = totalTime;
        }
        this.fireOverallUtilization(this.totalDemandedTime, totalTime);
        this.aResource.stop();
    }

    public static String getNextResourceId() {
        return Long.toString(resourceId++);
    }

    @Override
    public IActiveResource getScheduledResource() {
        return this.aResource;
    }

    public void update(int state, int instanceId) {
        this.fireStateEvent(state, instanceId);
    }
}

