/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.resources;

import de.uka.ipd.sdq.probespec.framework.ProbeSample;
import de.uka.ipd.sdq.probespec.framework.ProbeSpecContext;
import de.uka.ipd.sdq.probespec.framework.ProbeType;
import de.uka.ipd.sdq.probespec.framework.RequestContext;
import de.uka.ipd.sdq.probespec.framework.probes.IProbeStrategy;
import de.uka.ipd.sdq.probespec.framework.utils.ProbeSpecUtils;
import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.sensors.IPassiveResourceSensor;
import de.uka.ipd.sdq.simucomframework.DiscardInvalidMeasurementsBlackboardDecorator;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.ISimulationControlDelegate;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.SimProcess;
import de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.IDemandListener;
import de.uka.ipd.sdq.simucomframework.resources.IOverallUtilizationListener;
import de.uka.ipd.sdq.simucomframework.resources.IStateListener;

public class CalculatorHelper {
    public static void setupWaitingTimeCalculator(IPassiveResource resource, final ISimulationControlDelegate simControl) {
        final Integer startWaitingProbeSetId = ProbeSpecContext.instance().obtainProbeSetId("startWaitingPsvRes_" + resource.getId());
        final Integer stopWaitingProbeSetId = ProbeSpecContext.instance().obtainProbeSetId("stopWaitingPsvRes_" + resource.getId());
        ProbeSpecContext.instance().getCalculatorFactory().buildWaitingTimeCalculator("Passive Resource " + resource.getName() + " " + resource.getId(), startWaitingProbeSetId, stopWaitingProbeSetId);
        resource.addObserver(new IPassiveResourceSensor(){

            public void request(ISchedulableProcess process, int num) {
                ProbeSample currentTimeSample = CalculatorHelper.takeCurrentTimeSample(simControl);
                ProbeSpecContext.instance().getSampleBlackboard().addSample(ProbeSpecUtils.buildProbeSetSample((ProbeSample)currentTimeSample, (RequestContext)((SimProcess)process).getRequestContext(), (String)"", (Integer)startWaitingProbeSetId));
            }

            public void acquire(ISchedulableProcess process, int num) {
                ProbeSample currentTimeSample = CalculatorHelper.takeCurrentTimeSample(simControl);
                ProbeSpecContext.instance().getSampleBlackboard().addSample(ProbeSpecUtils.buildProbeSetSample((ProbeSample)currentTimeSample, (RequestContext)((SimProcess)process).getRequestContext(), (String)"", (Integer)stopWaitingProbeSetId));
            }

            public void release(ISchedulableProcess process, int num) {
            }
        });
    }

    public static void setupHoldTimeCalculator(IPassiveResource resource, final ISimulationControlDelegate simControl) {
        final Integer startHoldProbeSetId = ProbeSpecContext.instance().obtainProbeSetId("startHoldPsvRes_" + resource.getId());
        final Integer stopHoldProbeSetId = ProbeSpecContext.instance().obtainProbeSetId("stopHoldPsvRes_" + resource.getId());
        ProbeSpecContext.instance().getCalculatorFactory().buildHoldTimeCalculator("Passive Resource " + resource.getName() + " " + resource.getId(), startHoldProbeSetId, stopHoldProbeSetId);
        resource.addObserver(new IPassiveResourceSensor(){

            public void request(ISchedulableProcess process, int num) {
            }

            public void acquire(ISchedulableProcess process, int num) {
                ProbeSample currentTimeSample = CalculatorHelper.takeCurrentTimeSample(simControl);
                ProbeSpecContext.instance().getSampleBlackboard().addSample(ProbeSpecUtils.buildProbeSetSample((ProbeSample)currentTimeSample, (RequestContext)((SimProcess)process).getRequestContext(), (String)"", (Integer)startHoldProbeSetId));
            }

            public void release(ISchedulableProcess process, int num) {
                ProbeSample currentTimeSample = CalculatorHelper.takeCurrentTimeSample(simControl);
                ProbeSpecContext.instance().getSampleBlackboard().addSample(ProbeSpecUtils.buildProbeSetSample((ProbeSample)currentTimeSample, (RequestContext)((SimProcess)process).getRequestContext(), (String)"", (Integer)stopHoldProbeSetId));
            }
        });
    }

    public static void setupDemandCalculator(final AbstractScheduledResource r) {
        final Integer demandedTimeProbeSetId = ProbeSpecContext.instance().obtainProbeSetId("demandedTimeSchedRes_" + r.getDescription());
        ProbeSpecContext.instance().getCalculatorFactory().buildDemandCalculator(r.getDescription(), demandedTimeProbeSetId);
        r.addDemandListener(new IDemandListener(){

            @Override
            public void demand(double demand) {
                ProbeSample currentTimeSample = CalculatorHelper.takeCurrentTimeSample(r);
                ProbeSample demandedTimeSample = CalculatorHelper.takeDemandedTimeSample(r, demand);
                RequestContext context = new RequestContext("");
                ProbeSpecContext.instance().getSampleBlackboard().addSample(ProbeSpecUtils.buildProbeSetSample((ProbeSample)currentTimeSample, (ProbeSample)demandedTimeSample, (RequestContext)context, (String)"", (Integer)demandedTimeProbeSetId));
            }
        });
    }

    public static void setupStateCalculator(final AbstractScheduledResource r) {
        int instance = 0;
        while (instance < r.getNumberOfInstances()) {
            String instanceDescription = r.getDescription();
            if (r.getNumberOfInstances() > 1) {
                instanceDescription = "Core " + (instance + 1) + " " + instanceDescription;
            }
            final Integer stateProbeSetID = ProbeSpecContext.instance().obtainProbeSetId("state_" + instanceDescription);
            ProbeSpecContext.instance().getCalculatorFactory().buildStateCalculator(instanceDescription, stateProbeSetID);
            r.addStateListener(new IStateListener(){

                @Override
                public void stateChanged(int state, int instanceId) {
                    ProbeSample currentTimeSample = CalculatorHelper.takeCurrentTimeSample(r);
                    ProbeSample stateSample = CalculatorHelper.takeStateProbe(state);
                    RequestContext context = new RequestContext("");
                    ProbeSpecContext.instance().getSampleBlackboard().addSample(ProbeSpecUtils.buildProbeSetSample((ProbeSample)currentTimeSample, (ProbeSample)stateSample, (RequestContext)context, (String)"", (Integer)stateProbeSetID));
                }
            }, instance);
            ++instance;
        }
    }

    public static void setupOverallUtilizationCalculator(AbstractScheduledResource r) {
        final Integer stateProbeSetID = ProbeSpecContext.instance().obtainProbeSetId("overallUtilization_" + r.getDescription());
        ProbeSpecContext.instance().getCalculatorFactory().buildOverallUtilizationCalculator(r.getDescription(), stateProbeSetID);
        r.addOverallUtilizationListener(new IOverallUtilizationListener(){

            @Override
            public void utilizationChanged(double resourceDemand, double totalTime) {
                if (!(ProbeSpecContext.instance().getSampleBlackboard() instanceof DiscardInvalidMeasurementsBlackboardDecorator)) {
                    return;
                }
                DiscardInvalidMeasurementsBlackboardDecorator blackboard = (DiscardInvalidMeasurementsBlackboardDecorator)ProbeSpecContext.instance().getSampleBlackboard();
                RequestContext context = new RequestContext("");
                blackboard.addSampleAfterSimulationEnd(ProbeSpecUtils.buildProbeSetSample((ProbeSample)CalculatorHelper.takeTimeSample(0.0), (ProbeSample)CalculatorHelper.takeStateProbe(1), (RequestContext)context, (String)"", (Integer)stateProbeSetID));
                blackboard.addSampleAfterSimulationEnd(ProbeSpecUtils.buildProbeSetSample((ProbeSample)CalculatorHelper.takeTimeSample(resourceDemand), (ProbeSample)CalculatorHelper.takeStateProbe(0), (RequestContext)context, (String)"", (Integer)stateProbeSetID));
                blackboard.addSampleAfterSimulationEnd(ProbeSpecUtils.buildProbeSetSample((ProbeSample)CalculatorHelper.takeTimeSample(totalTime), (ProbeSample)CalculatorHelper.takeStateProbe(1), (RequestContext)context, (String)"", (Integer)stateProbeSetID));
            }
        });
    }

    public static void setupStateCalculator(final IPassiveResource resource, final ISimulationControlDelegate simControl) {
        final Integer stateProbeSetID = ProbeSpecContext.instance().obtainProbeSetId("state_" + resource.getName() + " " + resource.getId());
        ProbeSpecContext.instance().getCalculatorFactory().buildStateCalculator("Passive Resource " + resource.getName() + " " + resource.getId(), stateProbeSetID);
        resource.addObserver(new IPassiveResourceSensor(){

            public void request(ISchedulableProcess process, int num) {
            }

            public void release(ISchedulableProcess process, int num) {
                this.measureState();
            }

            public void acquire(ISchedulableProcess process, int num) {
                this.measureState();
            }

            private void measureState() {
                ProbeSample currentTimeSample = CalculatorHelper.takeCurrentTimeSample(simControl);
                ProbeSample stateSample = CalculatorHelper.takeStateProbe(resource);
                RequestContext context = new RequestContext("");
                ProbeSpecContext.instance().getSampleBlackboard().addSample(ProbeSpecUtils.buildProbeSetSample((ProbeSample)currentTimeSample, (ProbeSample)stateSample, (RequestContext)context, (String)"", (Integer)stateProbeSetID));
            }
        });
    }

    private static ProbeSample takeCurrentTimeSample(SimProcess thread) {
        IProbeStrategy probeStrategy = ProbeSpecContext.instance().getProbeStrategyRegistry().getProbeStrategy(ProbeType.CURRENT_TIME, null);
        ProbeSample currentTimeSample = probeStrategy.takeSample("TODO: probeId", new Object[]{thread.getModel().getSimulationControl()});
        return currentTimeSample;
    }

    private static ProbeSample takeCurrentTimeSample(ISimulationControlDelegate simControl) {
        IProbeStrategy probeStrategy = ProbeSpecContext.instance().getProbeStrategyRegistry().getProbeStrategy(ProbeType.CURRENT_TIME, null);
        ProbeSample currentTimeSample = probeStrategy.takeSample("TODO: probeId", new Object[]{simControl});
        return currentTimeSample;
    }

    private static ProbeSample takeCurrentTimeSample(AbstractScheduledResource r) {
        IProbeStrategy probeStrategy = ProbeSpecContext.instance().getProbeStrategyRegistry().getProbeStrategy(ProbeType.CURRENT_TIME, null);
        ProbeSample currentTimeSample = probeStrategy.takeSample("TODO: probeId", new Object[]{r.getModel().getSimulationControl()});
        return currentTimeSample;
    }

    private static ProbeSample takeTimeSample(Double time) {
        IProbeStrategy probeStrategy = ProbeSpecContext.instance().getProbeStrategyRegistry().getProbeStrategy(ProbeType.CURRENT_TIME, null);
        ProbeSample currentTimeSample = probeStrategy.takeSample("TODO: probeId", new Object[]{time});
        return currentTimeSample;
    }

    private static ProbeSample takeDemandedTimeSample(AbstractScheduledResource r, Double demand) {
        IProbeStrategy probeStrategy = ProbeSpecContext.instance().getProbeStrategyRegistry().getProbeStrategy(ProbeType.RESOURCE_DEMAND, AbstractScheduledResource.class);
        ProbeSample demandedTimeSample = probeStrategy.takeSample("TODO: probeId", new Object[]{demand});
        return demandedTimeSample;
    }

    private static ProbeSample takeStateProbe(int state) {
        IProbeStrategy probeStrategy = ProbeSpecContext.instance().getProbeStrategyRegistry().getProbeStrategy(ProbeType.RESOURCE_STATE, AbstractScheduledResource.class);
        ProbeSample stateSample = probeStrategy.takeSample("TODO: probeId", new Object[]{state});
        return stateSample;
    }

    private static ProbeSample takeStateProbe(IPassiveResource r) {
        IProbeStrategy probeStrategy = ProbeSpecContext.instance().getProbeStrategyRegistry().getProbeStrategy(ProbeType.RESOURCE_STATE, IPassiveResource.class);
        ProbeSample stateSample = probeStrategy.takeSample("TODO: probeId", new Object[]{r});
        return stateSample;
    }
}

