/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.resources;

import de.uka.ipd.sdq.simucomframework.abstractSimEngine.SimProcess;
import de.uka.ipd.sdq.simucomframework.exceptions.ResourceContainerIsMissingRequiredResourceType;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class AbstractSimulatedResourceContainer {
    protected static Logger logger = Logger.getLogger((String)AbstractSimulatedResourceContainer.class.getName());
    protected SimuComModel myModel = null;
    protected String myContainerID = null;
    protected HashMap<String, AbstractScheduledResource> activeResources = new HashMap();

    public AbstractSimulatedResourceContainer(SimuComModel myModel, String myContainerID) {
        this.myModel = myModel;
        this.myContainerID = myContainerID;
        logger.info((Object)("Simulated Resource Container created. ContainerID " + myContainerID));
    }

    public void loadActiveResource(SimProcess requestingProcess, String typeID, double demand) {
        AbstractScheduledResource resource = this.activeResources.get(typeID);
        if (resource == null) {
            logger.error((Object)("Resource container is missing a resource which was attempted to be loaded by a component. ID of resource type was: " + typeID));
            throw new ResourceContainerIsMissingRequiredResourceType(typeID);
        }
        resource.consumeResource(requestingProcess, demand);
    }

    public Collection<AbstractScheduledResource> getActiveResources() {
        return this.activeResources.values();
    }

    public String getResourceContainerID() {
        return this.myContainerID;
    }
}

