/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.resources;

import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.simucomframework.Context;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.Entity;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.SimProcess;
import de.uka.ipd.sdq.simucomframework.exceptions.EnvironmentFailureException;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.IDemandListener;
import de.uka.ipd.sdq.simucomframework.resources.IOverallUtilizationListener;
import de.uka.ipd.sdq.simucomframework.resources.IStateListener;
import de.uka.ipd.sdq.simucomframework.resources.ResourceFailedEvent;
import de.uka.ipd.sdq.simucomframework.resources.ResourceRepairedEvent;
import de.uka.ipd.sdq.simucomframework.resources.SchedulingStrategy;
import de.uka.ipd.sdq.simucomframework.simucomstatus.ActiveResouce;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimucomstatusFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractScheduledResource
extends Entity {
    public static final double EPSILON = Math.pow(10.0, -9.0);
    protected static Logger logger = Logger.getLogger((String)AbstractScheduledResource.class.getName());
    private Map<Integer, List<IStateListener>> stateListener;
    private List<IDemandListener> demandListener;
    private List<IOverallUtilizationListener> overallUtilizationListener;
    protected double mttf = 0.0;
    protected double mttr = 0.0;
    protected boolean canBeUnavailable = false;
    protected boolean isAvailable = true;
    protected ResourceFailedEvent failedEvent;
    protected ResourceRepairedEvent repairedEvent;
    protected boolean canFail = false;
    protected double failureProbability = 0.0;
    private ActiveResouce myResourceStatus;
    private boolean isStopped = false;
    private String description;
    private int numberOfInstances;

    public AbstractScheduledResource(SimuComModel myModel, String id, String description, SchedulingStrategy strategy, int numberOfInstances) {
        super(myModel, id);
        this.description = description;
        this.numberOfInstances = numberOfInstances;
        logger.info((Object)("Creating Simulated Active Resource: " + this.getName()));
        this.myResourceStatus = SimucomstatusFactory.eINSTANCE.createActiveResouce();
        this.myResourceStatus.setId(this.getName());
        myModel.getSimulationStatus().getResourceStatus().getActiveResources().add((Object)this.myResourceStatus);
        this.stateListener = new HashMap<Integer, List<IStateListener>>();
        int instance = 0;
        while (instance < numberOfInstances) {
            this.stateListener.put(instance, new ArrayList());
            ++instance;
        }
        this.overallUtilizationListener = new ArrayList<IOverallUtilizationListener>();
        this.demandListener = new ArrayList<IDemandListener>();
    }

    public abstract void consumeResource(SimProcess var1, double var2);

    protected abstract double calculateDemand(double var1);

    public void activateResource() {
        logger.debug((Object)("Starting resource " + this.getName()));
        if (this.canBeUnavailable) {
            double t = this.getFailureTime();
            this.failedEvent.schedule(this, t);
        }
    }

    public void deactivateResource() {
        if (!this.isStopped) {
            logger.debug((Object)("Stopping resource " + this.getName()));
            this.isStopped = true;
            int instance = 0;
            while (instance < this.numberOfInstances) {
                this.fireStateEvent(0, instance);
                ++instance;
            }
            this.getModel().getSimulationStatus().getResourceStatus().getActiveResources().remove((Object)this.myResourceStatus);
            if (this.canBeUnavailable) {
                this.failedEvent.removeEvent();
                this.repairedEvent.removeEvent();
            }
        }
    }

    public abstract IActiveResource getScheduledResource();

    public void setAvailable(boolean isAvailable) {
        this.isAvailable = isAvailable;
        double time = this.getModel().getSimulationControl().getCurrentSimulationTime();
        String status = this.isAvailable ? "available" : "unavailable";
        logger.debug((Object)("Resource " + this.getName() + " " + status + " at sim time " + time));
    }

    public double getFailureTime() {
        if (!this.canBeUnavailable) {
            throw new RuntimeException("getFailureTime() should not be invoked as resource cannot fail");
        }
        double failureTimeSample = (Double)Context.evaluateStatic((String)("Exp(1/" + this.mttf + ")"), Double.class);
        logger.debug((Object)("Resource will fail at sim time +" + failureTimeSample));
        return failureTimeSample;
    }

    public double getRepairTime() {
        if (!this.canBeUnavailable) {
            throw new RuntimeException("getRepairTime() should not be invoked as resource cannot fail");
        }
        double repairTimeSample = (Double)Context.evaluateStatic((String)("Exp(1/" + this.mttr + ")"), Double.class);
        logger.debug((Object)("Resource will be repaired at sim time +" + repairTimeSample));
        return repairTimeSample;
    }

    public double getFailureProbability() {
        return this.canFail ? this.failureProbability : 0.0;
    }

    protected void createAvailabilityEvents(SimuComModel model) {
        this.failedEvent = new ResourceFailedEvent(model, "ResourceFailed");
        this.repairedEvent = new ResourceRepairedEvent(model, "ResourceRepaired");
        this.failedEvent.setResource(this);
        this.failedEvent.setRepairedEvent(this.repairedEvent);
        this.repairedEvent.setResource(this);
        this.repairedEvent.setFailedEvent(this.failedEvent);
    }

    protected void assertAvailability() {
        if (!this.isAvailable) {
            EnvironmentFailureException.raise(this.getName());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public void addStateListener(IStateListener listener, int instance) {
        this.stateListener.get(instance).add(listener);
    }

    public void addOverallUtilizationListener(IOverallUtilizationListener listener) {
        this.overallUtilizationListener.add(listener);
    }

    protected void fireStateEvent(int queueLength, int instance) {
        for (IStateListener l : this.stateListener.get(instance)) {
            l.stateChanged(queueLength, instance);
        }
    }

    protected void fireOverallUtilization(double resourceDemand, double totalTime) {
        for (IOverallUtilizationListener l : this.overallUtilizationListener) {
            l.utilizationChanged(resourceDemand, totalTime);
        }
    }

    public void addDemandListener(IDemandListener listener) {
        this.demandListener.add(listener);
    }

    protected void fireDemand(double demand) {
        for (IDemandListener l : this.demandListener) {
            l.demand(demand);
        }
    }
}

