/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.probes;

import de.uka.ipd.sdq.probespec.framework.ProbeSample;
import de.uka.ipd.sdq.probespec.framework.ProbeType;
import de.uka.ipd.sdq.probespec.framework.probes.IProbeStrategy;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.ISimulationControlDelegate;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;

public class TakeSimulatedTimeStrategy
implements IProbeStrategy {
    public ProbeSample<Double, Duration> takeSample(String probeId, Object ... o) {
        double simTime = 0.0;
        if (o.length >= 1 && (o[0] instanceof ISimulationControlDelegate || o[0] instanceof Double)) {
            if (o[0] instanceof ISimulationControlDelegate) {
                ISimulationControlDelegate simControl = (ISimulationControlDelegate)o[0];
                simTime = simControl.getCurrentSimulationTime();
            } else {
                simTime = (Double)o[0];
            }
        } else {
            throw new IllegalArgumentException("Expected an argument implementing " + ISimulationControlDelegate.class.getSimpleName() + " or an argument of type " + Double.class.getSimpleName() + ".");
        }
        Measure time = Measure.valueOf((double)simTime, (Unit)SI.SECOND);
        ProbeSample sample = new ProbeSample(time, probeId, ProbeType.CURRENT_TIME);
        return sample;
    }
}

