/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.model;

import de.uka.ipd.sdq.probespec.framework.ISampleBlackboard;
import de.uka.ipd.sdq.probespec.framework.ProbeSpecContext;
import de.uka.ipd.sdq.probespec.framework.calculator.ICalculatorFactory;
import de.uka.ipd.sdq.probespec.framework.concurrency.ConcurrentSampleBlackboard;
import de.uka.ipd.sdq.probespec.framework.garbagecollection.IRegionBasedGarbageCollector;
import de.uka.ipd.sdq.probespec.framework.probes.IProbeStrategyRegistry;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.simucomframework.DiscardInvalidMeasurementsBlackboardDecorator;
import de.uka.ipd.sdq.simucomframework.ResourceRegistry;
import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import de.uka.ipd.sdq.simucomframework.SimuComGarbageCollector;
import de.uka.ipd.sdq.simucomframework.SimuComResult;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.ISimEngineFactory;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.ISimulationControlDelegate;
import de.uka.ipd.sdq.simucomframework.calculator.CalculatorFactory;
import de.uka.ipd.sdq.simucomframework.calculator.SetupPipesAndFiltersStrategy;
import de.uka.ipd.sdq.simucomframework.probes.SimuComProbeStrategyRegistry;
import de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.IResourceContainerFactory;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedLinkingResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.simucomstatus.Action;
import de.uka.ipd.sdq.simucomframework.simucomstatus.Process;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimuComStatus;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimucomstatusPackage;
import de.uka.ipd.sdq.simucomframework.usage.IWorkloadDriver;
import de.uka.ipd.sdq.simucomframework.variables.cache.StoExCache;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class SimuComModel {
    protected static Logger logger = Logger.getLogger((String)SimuComModel.class.getName());
    protected ResourceRegistry resourceRegistry = null;
    private IWorkloadDriver[] workloadDrivers;
    private SimuComResult status = SimuComResult.OK;
    private Throwable errorMessage = null;
    private SimuComConfig config;
    private long mainMeasurementsCount;
    private ISimEngineFactory simulationEngineFactory;
    private ISimulationControlDelegate simControl;
    private SimuComStatus simulationStatus = null;

    public SimuComModel(SimuComConfig config, SimuComStatus status, ISimEngineFactory factory, boolean isRemoteRun) {
        this.config = config;
        this.simulationEngineFactory = factory;
        this.simControl = factory.createSimulationControl(this);
        this.resourceRegistry = new ResourceRegistry(this);
        this.simulationStatus = status;
        StoExCache.initialiseStoExCache((IRandomGenerator)config.getRandomGenerator());
        DiscardInvalidMeasurementsBlackboardDecorator sampleBlackboard = new DiscardInvalidMeasurementsBlackboardDecorator((ISampleBlackboard)new ConcurrentSampleBlackboard(), this.simControl);
        ProbeSpecContext.instance().initialise((ISampleBlackboard)sampleBlackboard, (IRegionBasedGarbageCollector)new SimuComGarbageCollector(sampleBlackboard), (IProbeStrategyRegistry)new SimuComProbeStrategyRegistry(), (ICalculatorFactory)new CalculatorFactory(sampleBlackboard, this, new SetupPipesAndFiltersStrategy(this)));
    }

    private void initialiseSimStatus() {
        if (this.config.getVerboseLogging()) {
            EContentAdapter contentAdapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    super.notifyChanged(notification);
                    if (notification.getEventType() == 1) {
                        if (notification.getFeature() == SimucomstatusPackage.eINSTANCE.getProcess_CurrentAction()) {
                            Process p = (Process)notification.getNotifier();
                            Action a = (Action)notification.getNewValue();
                            logger.debug((Object)("Process " + p.getId() + " changed currentAction to " + a.getClass().getName()));
                        }
                    } else {
                        logger.debug((Object)"Simulation Status Updated");
                    }
                }
            };
            this.simulationStatus.eAdapters().add((Object)contentAdapter);
        }
    }

    public void doInitialSchedules() {
        IWorkloadDriver[] iWorkloadDriverArray = this.workloadDrivers;
        int n = this.workloadDrivers.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkloadDriver w = iWorkloadDriverArray[n2];
            w.run();
            ++n2;
        }
    }

    public void setUsageScenarios(IWorkloadDriver[] workload) {
        this.workloadDrivers = workload;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    public void initialiseResourceContainer(IResourceContainerFactory resourceContainerFactory) {
        AbstractSimulatedResourceContainer rc;
        String id;
        String[] stringArray = resourceContainerFactory.getResourceContainerIDList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            id = stringArray[n2];
            rc = (SimulatedResourceContainer)this.resourceRegistry.createResourceContainer(id);
            resourceContainerFactory.fillResourceContainer((SimulatedResourceContainer)rc);
            ++n2;
        }
        stringArray = resourceContainerFactory.getLinkingResourceContainerIDList();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            id = stringArray[n2];
            rc = (SimulatedLinkingResourceContainer)this.resourceRegistry.createLinkingResourceContainer(id);
            resourceContainerFactory.fillLinkingResourceContainer((SimulatedLinkingResourceContainer)rc);
            ++n2;
        }
        this.resourceRegistry.activateAllActiveResources();
    }

    public void setStatus(SimuComResult error, Throwable t) {
        this.status = error;
        this.errorMessage = t;
    }

    public SimuComResult getErrorStatus() {
        return this.status;
    }

    public Throwable getErrorThrowable() {
        return this.errorMessage;
    }

    public SimuComConfig getConfig() {
        return this.config;
    }

    public void increaseMainMeasurementsCount() {
        ++this.mainMeasurementsCount;
    }

    public long getMainMeasurementsCount() {
        return this.mainMeasurementsCount;
    }

    public ISimulationControlDelegate getSimulationControl() {
        return this.simControl;
    }

    public void setSimulationControl(ISimulationControlDelegate control) {
        this.simControl = control;
    }

    public void setSimulationEngineFactory(ISimEngineFactory factory) {
        this.simulationEngineFactory = factory;
    }

    public ISimEngineFactory getSimEngineFactory() {
        return this.simulationEngineFactory;
    }

    public SimuComStatus getSimulationStatus() {
        return this.simulationStatus;
    }
}

