/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.fork;

import de.uka.ipd.sdq.probespec.framework.ProbeSpecContext;
import de.uka.ipd.sdq.probespec.framework.RequestContext;
import de.uka.ipd.sdq.probespec.framework.garbagecollection.IRegionBasedGarbageCollector;
import de.uka.ipd.sdq.simucomframework.Context;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.ISimProcessDelegate;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.SimProcess;
import de.uka.ipd.sdq.simucomframework.fork.ForkContext;
import org.apache.log4j.Logger;

public abstract class ForkedBehaviourProcess
extends SimProcess {
    protected Context ctx;
    private ISimProcessDelegate myParent;
    protected String assemblyContextID;
    private boolean isAsync;
    private boolean isTerminated = false;
    private IRegionBasedGarbageCollector<RequestContext> blackboardGarbageCollector;
    private static Logger logger = Logger.getLogger((String)ForkedBehaviourProcess.class.getName());

    public ForkedBehaviourProcess(Context myContext, String assemblyContextID, boolean isAsync) {
        super(myContext.getModel(), "Forked Behaviour", myContext.getThread().getRequestContext());
        this.currentSessionId = myContext.getThread().getCurrentSessionId();
        this.ctx = new ForkContext(myContext, this);
        this.myParent = myContext.getThread();
        this.assemblyContextID = assemblyContextID;
        this.isAsync = isAsync;
        this.blackboardGarbageCollector = ProbeSpecContext.instance().getBlackboardGarbageCollector();
    }

    @Override
    protected void internalLifeCycle() {
        this.blackboardGarbageCollector.enterRegion((Object)this.getRequestContext().rootContext());
        this.executeBehaviour();
        this.blackboardGarbageCollector.leaveRegion((Object)this.getRequestContext().rootContext());
        this.isTerminated = true;
        if (!this.isAsync && !this.myParent.isTerminated() && this.simulationIsRunning()) {
            this.myParent.scheduleAt(0.0);
        } else {
            logger.debug((Object)("Asynch behaviour finished at simtime " + this.getModel().getSimulationControl().getCurrentSimulationTime()));
        }
    }

    private boolean simulationIsRunning() {
        return this.ctx.getModel().getSimulationControl().isRunning();
    }

    protected abstract void executeBehaviour();

    public boolean isAsync() {
        return this.isAsync;
    }

    @Override
    public boolean isTerminated() {
        return this.isTerminated;
    }
}

