/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.fork;

import de.uka.ipd.sdq.simucomframework.abstractSimEngine.SimProcess;
import de.uka.ipd.sdq.simucomframework.fork.ForkedBehaviourProcess;
import org.apache.log4j.Logger;

public class ForkExecutor {
    private ForkedBehaviourProcess[] forks;
    private SimProcess parent;
    private static Logger logger = Logger.getLogger((String)ForkExecutor.class.getName());

    public ForkExecutor(SimProcess parent, ForkedBehaviourProcess[] forks) {
        this.forks = forks;
        this.parent = parent;
    }

    public void run() {
        logger.debug((Object)"Running parallel operations");
        double start = this.parent.getModel().getSimulationControl().getCurrentSimulationTime();
        ForkedBehaviourProcess[] forkedBehaviourProcessArray = this.forks;
        int n = this.forks.length;
        int n2 = 0;
        while (n2 < n) {
            ForkedBehaviourProcess p = forkedBehaviourProcessArray[n2];
            p.scheduleAt(0.0);
            ++n2;
        }
        while (this.checkIfRemainingChildrenRun()) {
            this.parent.passivate();
        }
        logger.debug((Object)("Forks took: " + (this.parent.getModel().getSimulationControl().getCurrentSimulationTime() - start)));
    }

    private boolean checkIfRemainingChildrenRun() {
        ForkedBehaviourProcess[] forkedBehaviourProcessArray = this.forks;
        int n = this.forks.length;
        int n2 = 0;
        while (n2 < n) {
            ForkedBehaviourProcess p = forkedBehaviourProcessArray[n2];
            if (!p.isAsync() && !p.isTerminated()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

