/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.exceptions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class FailureStatistics {
    private static FailureStatistics instance = new FailureStatistics();
    private HashSet<Long> failedRuns;
    private Map<String, Integer> handledFailureCounters;
    private Map<String, Integer> totalFailureCounters;
    private long runCount;
    private Map<String, Integer> unhandledFailureCounters;
    private long handledFailureCount;
    private long totalFailureCount;
    private long unhandledFailureCount;

    public static synchronized FailureStatistics getInstance() {
        return instance;
    }

    private FailureStatistics() {
        this.reset();
    }

    public Map<String, Integer> getHandledFailureCounters() {
        return this.handledFailureCounters;
    }

    public Map<String, Integer> getTotalFailureCounters() {
        return this.totalFailureCounters;
    }

    public long getRunCount() {
        return this.runCount;
    }

    public Map<String, Integer> getUnhandledFailureCounters() {
        return this.unhandledFailureCounters;
    }

    public long getHandledFailureCount() {
        return this.handledFailureCount;
    }

    public long getTotalFailureCount() {
        return this.totalFailureCount;
    }

    public long getUnhandledFailureCount() {
        return this.unhandledFailureCount;
    }

    public synchronized void increaseHandledFailureCounter(String type) {
        Integer count = this.handledFailureCounters.get(type);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.handledFailureCounters.put(type, count);
        ++this.handledFailureCount;
    }

    public synchronized void increaseTotalFailureCounter(String type) {
        Integer count = this.totalFailureCounters.get(type);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.totalFailureCounters.put(type, count);
        ++this.totalFailureCount;
    }

    public synchronized void increaseRunCount() {
        ++this.runCount;
    }

    public synchronized void increaseUnhandledFailureCounter(String type, Long sessionId) {
        Integer count = this.unhandledFailureCounters.get(type);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.unhandledFailureCounters.put(type, count);
        ++this.unhandledFailureCount;
        if (!this.failedRuns.contains(sessionId)) {
            this.failedRuns.add(sessionId);
        }
    }

    public void printFailureStatistics(Logger logger) {
        logger.warn((Object)"---- System Failure Statistics ----");
        logger.warn((Object)("Total usage scenario runs:        " + this.runCount));
        logger.warn((Object)("Total failed usage scenario runs: " + this.failedRuns.size()));
        logger.warn((Object)("Total probability of success:     " + (1.0 - (double)this.failedRuns.size() / (double)this.runCount)));
        for (String failureType : this.unhandledFailureCounters.keySet()) {
            double count = this.unhandledFailureCounters.get(failureType).intValue();
            logger.warn((Object)("Failure '" + failureType + "': " + (int)count + " (" + count / (double)this.runCount + ")"));
        }
        this.printHandledFailuresStatistics(logger);
    }

    public synchronized void printRunCount(Logger logger) {
        if (this.runCount % 1000L == 0L) {
            logger.warn((Object)("Current usage scenario runs: " + this.runCount));
        }
    }

    public void reset() {
        this.unhandledFailureCounters = new HashMap<String, Integer>();
        this.totalFailureCounters = new HashMap<String, Integer>();
        this.handledFailureCounters = new HashMap<String, Integer>();
        this.failedRuns = new HashSet();
        this.unhandledFailureCount = 0L;
        this.handledFailureCount = 0L;
        this.totalFailureCount = 0L;
        this.runCount = 0L;
    }

    private void printHandledFailuresStatistics(Logger logger) {
        logger.warn((Object)"---- Handled Failure Statistics ----");
        for (String failureType : this.handledFailureCounters.keySet()) {
            int handledCount = this.handledFailureCounters.get(failureType);
            Integer totalFailureCount = this.totalFailureCounters.get(failureType);
            if (totalFailureCount == null) {
                totalFailureCount = 0;
            }
            logger.warn((Object)("Failure '" + failureType + "': Handled " + handledCount + " out of " + totalFailureCount + " (" + (double)handledCount / (double)totalFailureCount.intValue() + ")"));
        }
    }
}

