/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.calculator;

import de.uka.ipd.sdq.pipesandfilters.framework.MetaDataInit;
import de.uka.ipd.sdq.pipesandfilters.framework.PipeData;
import de.uka.ipd.sdq.pipesandfilters.framework.PipeElement;
import de.uka.ipd.sdq.pipesandfilters.framework.PipesAndFiltersManager;
import de.uka.ipd.sdq.pipesandfilters.framework.recorder.IRawWriteStrategy;
import de.uka.ipd.sdq.pipesandfilters.framework.recorder.RawRecorder;
import de.uka.ipd.sdq.pipesandfilters.framework.recorder.launch.RecorderExtensionHelper;
import de.uka.ipd.sdq.probespec.framework.calculator.Calculator;
import de.uka.ipd.sdq.probespec.framework.calculator.ICalculatorListener;
import de.uka.ipd.sdq.simucomframework.calculator.ISetupDataSinkStrategy;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import org.eclipse.core.runtime.CoreException;

public class SetupConcurrentPipesAndFiltersStrategy
implements ISetupDataSinkStrategy {
    private SimuComModel model;

    public SetupConcurrentPipesAndFiltersStrategy(SimuComModel model) {
        this.model = model;
    }

    @Override
    public PipesAndFiltersManager setupDataSink(Calculator calculator, MetaDataInit metaData) {
        RawRecorder recorder = new RawRecorder(this.createWriteStrategy());
        PipesAndFiltersManager pipeManager = new PipesAndFiltersManager((PipeElement)recorder);
        pipeManager.initialize(metaData);
        final ProcessPipeData processPipeData = new ProcessPipeData(pipeManager);
        new Thread(processPipeData).start();
        calculator.addCalculatorListener(new ICalculatorListener(){

            public void calculated(Vector<Measure<?, ? extends Quantity>> resultTuple) {
                processPipeData.enqueue(new PipeData(resultTuple));
            }
        });
        return pipeManager;
    }

    private IRawWriteStrategy createWriteStrategy() {
        try {
            String writeStrategyClass = RecorderExtensionHelper.getWriteStrategyClassNameForName((String)this.model.getConfig().getRecorderName());
            return (IRawWriteStrategy)Class.forName(writeStrategyClass).newInstance();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private class ProcessPipeData
    implements Runnable {
        private LinkedBlockingQueue<PipeData> pipeQueue;
        private boolean keepRunning = true;
        private PipesAndFiltersManager pipeManager;

        public ProcessPipeData(PipesAndFiltersManager pipeManager) {
            this.pipeManager = pipeManager;
            this.pipeQueue = new LinkedBlockingQueue();
        }

        @Override
        public void run() {
            while (this.keepRunning) {
                try {
                    this.pipeManager.processData(this.pipeQueue.take());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void stop() {
            this.keepRunning = false;
        }

        public void enqueue(PipeData data) {
            try {
                this.pipeQueue.put(data);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

