/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.calculator;

import de.uka.ipd.sdq.pipesandfilters.framework.MetaDataInit;
import de.uka.ipd.sdq.pipesandfilters.framework.PipesAndFiltersManager;
import de.uka.ipd.sdq.pipesandfilters.framework.recorder.sensorframework.SensorFrameworkMetaDataInit;
import de.uka.ipd.sdq.pipesandfilters.framework.recorder.sensorframework.launch.SensorFrameworkConfig;
import de.uka.ipd.sdq.probespec.framework.ISampleBlackboard;
import de.uka.ipd.sdq.probespec.framework.ProbeSpecContext;
import de.uka.ipd.sdq.probespec.framework.calculator.Calculator;
import de.uka.ipd.sdq.probespec.framework.calculator.DemandBasedWaitingTimeCalculator;
import de.uka.ipd.sdq.probespec.framework.calculator.DemandCalculator;
import de.uka.ipd.sdq.probespec.framework.calculator.HoldTimeCalculator;
import de.uka.ipd.sdq.probespec.framework.calculator.ICalculatorFactory;
import de.uka.ipd.sdq.probespec.framework.calculator.ResponseTimeCalculator;
import de.uka.ipd.sdq.probespec.framework.calculator.StateCalculator;
import de.uka.ipd.sdq.probespec.framework.calculator.WaitingTimeCalculator;
import de.uka.ipd.sdq.simucomframework.calculator.ISetupDataSinkStrategy;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import java.util.Date;

public class CalculatorFactory
implements ICalculatorFactory {
    private ISampleBlackboard blackboard;
    private SimuComModel model;
    private String experimentRunName = "Run " + new Date();
    private ISetupDataSinkStrategy dataSink;

    public CalculatorFactory(ISampleBlackboard blackboard, SimuComModel model, ISetupDataSinkStrategy dataSink) {
        this.blackboard = blackboard;
        this.model = model;
        this.dataSink = dataSink;
    }

    public Calculator buildResponseTimeCalculator(String calculatorName, Integer startProbeSetID, Integer endProbeSetID) {
        ResponseTimeCalculator calculator = new ResponseTimeCalculator(this.blackboard, startProbeSetID, endProbeSetID);
        SensorFrameworkMetaDataInit metaData = new SensorFrameworkMetaDataInit(calculator.getMeasurementMetrics(), (SensorFrameworkConfig)this.model.getConfig().getRecorderConfig());
        metaData.setExperimentName(this.model.getConfig().getNameExperimentRun());
        metaData.setExperimentRunName(this.experimentRunName);
        metaData.setMeasurementName("Response Time of " + calculatorName);
        metaData.setMetricName("Response Time");
        PipesAndFiltersManager pipeManager = this.dataSink.setupDataSink((Calculator)calculator, (MetaDataInit)metaData);
        ProbeSpecContext.instance().getPipeManagerRegisty().register((Object)pipeManager);
        return calculator;
    }

    public WaitingTimeCalculator buildDemandBasedWaitingTimeCalculator(String calculatorName, Integer startWaitingProbeSetID, Integer stopProcessingProbeSetID) {
        DemandBasedWaitingTimeCalculator calculator = new DemandBasedWaitingTimeCalculator(this.blackboard, startWaitingProbeSetID, stopProcessingProbeSetID);
        SensorFrameworkMetaDataInit metaData = new SensorFrameworkMetaDataInit(calculator.getMeasurementMetrics(), (SensorFrameworkConfig)this.model.getConfig().getRecorderConfig());
        metaData.setExperimentName(this.model.getConfig().getNameExperimentRun());
        metaData.setExperimentRunName(this.experimentRunName);
        metaData.setMeasurementName(String.valueOf(this.model.getConfig().getNameExperimentRun()) + ": Wait time at " + calculatorName);
        metaData.setMetricName("Waiting Time");
        PipesAndFiltersManager pipeManager = this.dataSink.setupDataSink((Calculator)calculator, (MetaDataInit)metaData);
        ProbeSpecContext.instance().getPipeManagerRegisty().register((Object)pipeManager);
        return calculator;
    }

    public WaitingTimeCalculator buildWaitingTimeCalculator(String calculatorName, Integer startWaitingProbeSetID, Integer stopWaitingProbeSetID) {
        WaitingTimeCalculator calculator = new WaitingTimeCalculator(this.blackboard, startWaitingProbeSetID, stopWaitingProbeSetID);
        SensorFrameworkMetaDataInit metaData = new SensorFrameworkMetaDataInit(calculator.getMeasurementMetrics(), (SensorFrameworkConfig)this.model.getConfig().getRecorderConfig());
        metaData.setExperimentName(this.model.getConfig().getNameExperimentRun());
        metaData.setExperimentRunName(this.experimentRunName);
        metaData.setMeasurementName("Wait time at " + calculatorName);
        metaData.setMetricName("Waiting Time");
        PipesAndFiltersManager pipeManager = this.dataSink.setupDataSink((Calculator)calculator, (MetaDataInit)metaData);
        ProbeSpecContext.instance().getPipeManagerRegisty().register((Object)pipeManager);
        return calculator;
    }

    public HoldTimeCalculator buildHoldTimeCalculator(String calculatorName, Integer startHoldProbeSetID, Integer stopHoldProbeSetID) {
        HoldTimeCalculator calculator = new HoldTimeCalculator(this.blackboard, startHoldProbeSetID, stopHoldProbeSetID);
        SensorFrameworkMetaDataInit metaData = new SensorFrameworkMetaDataInit(calculator.getMeasurementMetrics(), (SensorFrameworkConfig)this.model.getConfig().getRecorderConfig());
        metaData.setExperimentName(this.model.getConfig().getNameExperimentRun());
        metaData.setExperimentRunName(this.experimentRunName);
        metaData.setMeasurementName("Hold time at " + calculatorName);
        metaData.setMetricName("Hold Time");
        PipesAndFiltersManager pipeManager = this.dataSink.setupDataSink((Calculator)calculator, (MetaDataInit)metaData);
        ProbeSpecContext.instance().getPipeManagerRegisty().register((Object)pipeManager);
        return calculator;
    }

    public StateCalculator buildStateCalculator(String calculatorName, Integer probeSetId) {
        StateCalculator calculator = new StateCalculator(this.blackboard, probeSetId);
        SensorFrameworkMetaDataInit metaData = new SensorFrameworkMetaDataInit(calculator.getMeasurementMetrics(), (SensorFrameworkConfig)this.model.getConfig().getRecorderConfig());
        metaData.setExperimentName(this.model.getConfig().getNameExperimentRun());
        metaData.setExperimentRunName(this.experimentRunName);
        metaData.setMeasurementName("Utilisation of " + calculatorName);
        metaData.setMetricName("Utilisation");
        PipesAndFiltersManager pipeManager = this.dataSink.setupDataSink((Calculator)calculator, (MetaDataInit)metaData);
        ProbeSpecContext.instance().getPipeManagerRegisty().register((Object)pipeManager);
        return calculator;
    }

    public DemandCalculator buildDemandCalculator(String calculatorName, Integer probeSetID) {
        DemandCalculator calculator = new DemandCalculator(this.blackboard, probeSetID);
        SensorFrameworkMetaDataInit metaData = new SensorFrameworkMetaDataInit(calculator.getMeasurementMetrics(), (SensorFrameworkConfig)this.model.getConfig().getRecorderConfig());
        metaData.setExperimentName(this.model.getConfig().getNameExperimentRun());
        metaData.setExperimentRunName(this.experimentRunName);
        metaData.setMeasurementName("Demanded time at " + calculatorName);
        metaData.setMetricName("Demanded Time");
        PipesAndFiltersManager pipeManager = this.dataSink.setupDataSink((Calculator)calculator, (MetaDataInit)metaData);
        ProbeSpecContext.instance().getPipeManagerRegisty().register((Object)pipeManager);
        return calculator;
    }

    public StateCalculator buildOverallUtilizationCalculator(String calculatorName, Integer probeSetId) {
        StateCalculator calculator = new StateCalculator(this.blackboard, probeSetId);
        SensorFrameworkMetaDataInit metaData = new SensorFrameworkMetaDataInit(calculator.getMeasurementMetrics(), (SensorFrameworkConfig)this.model.getConfig().getRecorderConfig());
        metaData.setExperimentName(this.model.getConfig().getNameExperimentRun());
        metaData.setExperimentRunName(this.experimentRunName);
        metaData.setMeasurementName("Overall Utilisation of " + calculatorName);
        metaData.setMetricName("Overall Utilisation");
        PipesAndFiltersManager pipeManager = this.dataSink.setupDataSink((Calculator)calculator, (MetaDataInit)metaData);
        ProbeSpecContext.instance().getPipeManagerRegisty().register((Object)pipeManager);
        return calculator;
    }
}

