/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.abstractSimEngine;

import de.uka.ipd.sdq.probespec.framework.RequestContext;
import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.LoggingWrapper;
import de.uka.ipd.sdq.scheduler.resources.active.SimDelayResource;
import de.uka.ipd.sdq.simucomframework.SimuComResult;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.ISimProcessDelegate;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.SimulationElement;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.simucomstatus.Process;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimucomstatusFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public abstract class SimProcess
extends SimulationElement
implements ISimProcessDelegate,
ISchedulableProcess {
    protected static Logger logger = Logger.getLogger((String)SimProcess.class.getName());
    ISimProcessDelegate delegate = null;
    private Process processStatus = null;
    private long id;
    private SimDelayResource delayResource = null;
    private boolean isDebug;
    private RequestContext requestContext;
    private static AtomicLong processID = new AtomicLong(0L);
    private static AtomicLong sessionID = new AtomicLong(0L);
    protected long currentSessionId;
    private ArrayList<IActiveResource> terminatedObservers = new ArrayList();
    private List<IActiveResource> removedObservers = new ArrayList<IActiveResource>();

    protected SimProcess(SimuComModel model, String name) {
        this(model, name, null);
    }

    protected SimProcess(SimuComModel model, String name, RequestContext parentRequestContext) {
        super(model, name);
        this.id = SimProcess.getNextID();
        this.isDebug = model.getConfig().isDebug();
        logger.debug((Object)("Create SimProcess with id " + this.id));
        this.delayResource = new SimDelayResource(String.valueOf(name) + "_thinktime", String.valueOf(name) + "_thinktime");
        this.delegate = model.getSimEngineFactory().createSimProcess(this, model, name);
        this.requestContext = new RequestContext(Long.valueOf(this.id).toString(), parentRequestContext);
    }

    public final void lifeCycle() {
        this.addProcessToSimStatus();
        try {
            this.internalLifeCycle();
            this.fireTerminated();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)"Simulation caused an exception. Caught it in SimProcess Lifecycle Method", (Throwable)e);
            this.getModel().setStatus(SimuComResult.ERROR, e);
            logger.debug((Object)"Trying to stop simulation now...");
            this.getModel().getSimulationControl().stop();
        }
        this.removeProcessFromSimStatus();
    }

    protected void removeProcessFromSimStatus() {
        logger.debug((Object)("Terminating SimProcess " + this.getName()));
        if (this.isDebug) {
            this.getModel().getSimulationStatus().getProcessStatus().getProcesses().remove((Object)this.processStatus);
        }
    }

    protected void addProcessToSimStatus() {
        logger.debug((Object)("Starting simulation process " + this.getName()));
        if (this.isDebug) {
            this.processStatus = SimucomstatusFactory.eINSTANCE.createProcess();
            this.getModel().getSimulationStatus().getProcessStatus().getProcesses().add((Object)this.processStatus);
            this.processStatus.setId(this.getName());
            this.processStatus.setProcessStartTime(this.getModel().getSimulationControl().getCurrentSimulationTime());
        }
    }

    protected abstract void internalLifeCycle();

    public void hold(double d) {
        this.delayResource.process((ISchedulableProcess)this, d);
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public void passivate() {
        this.delegate.passivate();
    }

    public void activate() {
        this.scheduleAt(0.0);
    }

    @Override
    public void scheduleAt(double d) {
        this.delegate.scheduleAt(d);
    }

    public String getId() {
        return String.valueOf(this.getName()) + "_" + this.id;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public ISchedulableProcess getRootProcess() {
        return null;
    }

    public boolean isFinished() {
        return this.isTerminated();
    }

    public Process getSimProcessStatus() {
        return this.processStatus;
    }

    protected static long getNextID() {
        return processID.incrementAndGet();
    }

    public long getCurrentSessionId() {
        return this.currentSessionId;
    }

    protected void updateNewSessionID() {
        this.currentSessionId = sessionID.incrementAndGet();
    }

    public void fireTerminated() {
        LoggingWrapper.log((String)("Process " + this.getId() + " terminated."));
        for (IActiveResource o : this.terminatedObservers) {
            o.notifyTerminated((ISchedulableProcess)this);
        }
        this.terminatedObservers.removeAll(this.removedObservers);
        this.removedObservers.clear();
    }

    public void addTerminatedObserver(IActiveResource r) {
        if (!this.terminatedObservers.contains(r)) {
            this.terminatedObservers.add(r);
        }
    }

    public void removeTerminatedObserver(IActiveResource r) {
        this.removedObservers.remove(r);
    }
}

