/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import umontreal.iro.lecuyer.rng.MRG32k3a;

public class SimuComDefaultRandomNumberGenerator
implements IRandomGenerator {
    private static final int MAX_PRODUCER_BUFFER_SIZE = 1000;
    private static Logger logger = Logger.getLogger((String)SimuComDefaultRandomNumberGenerator.class.getName());
    private static long streamCounter = 0L;
    private long myID;
    private MRG32k3a rndNumberGenerator = null;
    private LinkedBlockingQueue<Double> producerQueue = new LinkedBlockingQueue(1000);
    private Thread producerThread;
    private boolean finished = false;

    public SimuComDefaultRandomNumberGenerator(long[] randomSeed) {
        this.myID = streamCounter++;
        logger.debug((Object)("Initialising random number generator! [Stream ID = " + this.myID + "]"));
        this.rndNumberGenerator = new MRG32k3a();
        if (randomSeed != null) {
            if (randomSeed.length == 6) {
                logger.debug((Object)("Setting fixed seed for random number generator! [Stream ID = " + this.myID + "]"));
                int i = 0;
                while (i < 6) {
                    logger.debug((Object)("Seed " + i + " = " + randomSeed[i]));
                    ++i;
                }
                this.rndNumberGenerator.setSeed(randomSeed);
            } else {
                throw new RuntimeException("Seed array must have length of six longs for initialising random number generator");
            }
        }
        this.producerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                logger.debug((Object)("Random number producer started! [Stream ID = " + SimuComDefaultRandomNumberGenerator.this.myID + "]"));
                try {
                    while (!SimuComDefaultRandomNumberGenerator.this.finished) {
                        SimuComDefaultRandomNumberGenerator.this.producerQueue.put(SimuComDefaultRandomNumberGenerator.this.rndNumberGenerator.nextDouble());
                    }
                }
                catch (InterruptedException e) {
                    logger.debug((Object)"Bad concurrency problem", (Throwable)e);
                    throw new RuntimeException("Unexpected interruption of concurrent threads");
                }
                logger.debug((Object)("Random number producer stopped! [Stream ID = " + SimuComDefaultRandomNumberGenerator.this.myID + "]"));
            }
        });
        this.producerThread.start();
        logger.debug((Object)("Random number stream initialised! [Stream ID = " + this.myID + "]"));
    }

    public double random() {
        double d;
        logger.debug((Object)("Drawing a random number from random number stream [" + this.myID + "]!"));
        try {
            d = this.producerQueue.take();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Unexpected interruption of concurrent threads");
        }
        logger.debug((Object)("Number is: " + d));
        return d;
    }

    public void dispose() {
        this.finished = true;
        this.producerQueue.clear();
    }
}

