/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.pipesandfilters.framework.recorder.launch.IRecorderConfiguration;
import de.uka.ipd.sdq.pipesandfilters.framework.recorder.launch.RecorderExtensionHelper;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.simucomframework.SimuComDefaultRandomNumberGenerator;
import de.uka.ipd.sdq.workflow.pcm.runconfig.ExperimentRunDescriptor;
import java.io.Serializable;
import java.util.Map;
import org.eclipse.emf.common.util.URI;

public class SimuComConfig
implements Serializable {
    private static final long serialVersionUID = -3364130550065874984L;
    public static final String PERSISTENCE_RECORDER_NAME = "persistenceFramework";
    public static final String SHOULD_THROW_EXCEPTION = "shouldThrowException";
    public static final String MAXIMUM_MEASUREMENT_COUNT = "maximumMeasurementCount";
    public static final String USE_FIXED_SEED = "useFixedSeed";
    public static final String FIXED_SEED_PREFIX = "fixedSeed";
    public static String EXPERIMENT_RUN = "experimentRun";
    public static String SIMULATION_TIME = "simTime";
    public static String VERBOSE_LOGGING = "verboseLogging";
    public static String SIMULATE_FAILURES = "simulateFailures";
    public static String SIMULATE_LINKING_RESOURCES = "simulateLinkingResources";
    public static String USE_CONFIDENCE = "useConfidenceStopCondition";
    public static String CONFIDENCE_LEVEL = "confidenceLevel";
    public static String CONFIDENCE_HALFWIDTH = "confidenceHalfWidth";
    public static String CONFIDENCE_MODELELEMENT_URI = "confidenceModelElementURI";
    public static String CONFIDENCE_MODELELEMENT_NAME = "confidenceModelElementName";
    private String nameExperimentRun;
    private long simuTime;
    private boolean verboseLogging;
    private boolean simulateFailures = false;
    private boolean simulateLinkingResources = false;
    private Long maxMeasurementsCount;
    private boolean isDebug;
    private long[] randomSeed = null;
    private IRandomGenerator randomNumberGenerator = null;
    private boolean useConfidence = false;
    private int confidenceLevel = 0;
    private int confidenceHalfWidth = 0;
    private URI confidenceModelElementURI;
    private String confidenceModelElementName;
    private String recorderName;
    private IRecorderConfiguration recorderConfig;
    private ExperimentRunDescriptor descriptor = null;

    public SimuComConfig(Map<String, Object> configuration, boolean debug) {
        try {
            this.nameExperimentRun = (String)configuration.get(EXPERIMENT_RUN);
            this.simuTime = Long.valueOf((String)configuration.get(SIMULATION_TIME));
            this.maxMeasurementsCount = Long.valueOf((String)configuration.get(MAXIMUM_MEASUREMENT_COUNT));
            this.verboseLogging = (Boolean)configuration.get(VERBOSE_LOGGING);
            this.isDebug = debug;
            this.randomSeed = this.getSeedFromConfig(configuration);
            if (configuration.containsKey(SIMULATE_FAILURES)) {
                this.simulateFailures = (Boolean)configuration.get(SIMULATE_FAILURES);
            }
            if (configuration.containsKey(SIMULATE_LINKING_RESOURCES)) {
                this.simulateLinkingResources = (Boolean)configuration.get(SIMULATE_LINKING_RESOURCES);
            }
            if (configuration.containsKey(USE_CONFIDENCE)) {
                this.useConfidence = (Boolean)configuration.get(USE_CONFIDENCE);
                this.confidenceLevel = Integer.valueOf((String)configuration.get(CONFIDENCE_LEVEL));
                this.confidenceHalfWidth = Integer.valueOf((String)configuration.get(CONFIDENCE_HALFWIDTH));
                this.confidenceModelElementName = (String)configuration.get(CONFIDENCE_MODELELEMENT_NAME);
                this.confidenceModelElementURI = URI.createURI((String)((String)configuration.get(CONFIDENCE_MODELELEMENT_URI)));
            }
            this.recorderName = (String)configuration.get(PERSISTENCE_RECORDER_NAME);
            this.recorderConfig = RecorderExtensionHelper.getRecorderConfigForName((String)this.recorderName);
            if (this.recorderConfig != null) {
                this.recorderConfig.setConfiguration(configuration);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Setting up properties failed, please check launch config (check all tabs).", e);
        }
    }

    private long[] getSeedFromConfig(Map<String, Object> configuration) {
        if (((Boolean)configuration.get(USE_FIXED_SEED)).booleanValue()) {
            long[] seed = new long[6];
            int i = 0;
            while (i < 6) {
                seed[i] = Long.parseLong((String)configuration.get(FIXED_SEED_PREFIX + i));
                ++i;
            }
            return seed;
        }
        return null;
    }

    public String getNameExperimentRun() {
        if (this.descriptor != null) {
            return this.descriptor.getNameExperimentRun();
        }
        return this.getNameBase();
    }

    public String getNameBase() {
        return this.nameExperimentRun;
    }

    public long getSimuTime() {
        return this.simuTime;
    }

    public long getMaxMeasurementsCount() {
        return this.maxMeasurementsCount;
    }

    public boolean getVerboseLogging() {
        return this.verboseLogging || this.isDebug;
    }

    public boolean getSimulateFailures() {
        return this.simulateFailures;
    }

    public boolean getSimulateLinkingResources() {
        return this.simulateLinkingResources;
    }

    public String getRecorderName() {
        return this.recorderName;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isUseConfidence() {
        return this.useConfidence;
    }

    public int getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public int getConfidenceHalfWidth() {
        return this.confidenceHalfWidth;
    }

    public String getConfidenceModelElementName() {
        return this.confidenceModelElementName;
    }

    public URI getConfidenceModelElementURI() {
        return this.confidenceModelElementURI;
    }

    public String getEngine() {
        return "de.uka.ipd.sdq.simucomframework.ssj.SSJSimEngineFactory";
    }

    public IRandomGenerator getRandomGenerator() {
        if (this.randomNumberGenerator == null) {
            this.randomNumberGenerator = new SimuComDefaultRandomNumberGenerator(this.randomSeed);
        }
        return this.randomNumberGenerator;
    }

    public void setExperimentRunDescriptor(ExperimentRunDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ExperimentRunDescriptor getExperimentRunDescriptor() {
        return this.descriptor;
    }

    public IRecorderConfiguration getRecorderConfig() {
        return this.recorderConfig;
    }

    private SimuComConfig() {
    }

    public SimuComConfig copy(ExperimentRunDescriptor descriptor) {
        SimuComConfig result = new SimuComConfig();
        result.descriptor = descriptor;
        result.nameExperimentRun = this.nameExperimentRun;
        result.confidenceHalfWidth = this.confidenceHalfWidth;
        result.confidenceLevel = this.confidenceLevel;
        result.confidenceModelElementName = this.confidenceModelElementName;
        result.confidenceModelElementURI = this.confidenceModelElementURI;
        result.isDebug = this.isDebug;
        result.maxMeasurementsCount = this.maxMeasurementsCount;
        result.randomSeed = this.randomSeed;
        result.recorderConfig = this.recorderConfig;
        result.recorderName = this.recorderName;
        result.simulateFailures = this.simulateFailures;
        result.simulateLinkingResources = this.simulateLinkingResources;
        result.simuTime = this.simuTime;
        result.useConfidence = this.useConfidence;
        result.verboseLogging = this.verboseLogging;
        return result;
    }
}

