/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedLinkingResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedResourceContainer;
import java.util.ArrayList;
import java.util.HashMap;

public class ResourceRegistry {
    private HashMap<String, AbstractSimulatedResourceContainer> resourceContainerHash = new HashMap();
    private SimuComModel myModel = null;

    public ResourceRegistry(SimuComModel model) {
        this.myModel = model;
    }

    public AbstractSimulatedResourceContainer createResourceContainer(String containerID) {
        if (!this.resourceContainerHash.containsKey(containerID)) {
            SimulatedResourceContainer container = new SimulatedResourceContainer(this.myModel, containerID);
            this.resourceContainerHash.put(containerID, container);
        }
        return this.resourceContainerHash.get(containerID);
    }

    public AbstractSimulatedResourceContainer createLinkingResourceContainer(String containerID) {
        if (!this.resourceContainerHash.containsKey(containerID)) {
            SimulatedLinkingResourceContainer container = new SimulatedLinkingResourceContainer(this.myModel, containerID);
            this.resourceContainerHash.put(containerID, container);
        }
        return this.resourceContainerHash.get(containerID);
    }

    public boolean containsResourceContainer(String resourceContainerID) {
        return this.resourceContainerHash.containsKey(resourceContainerID);
    }

    public AbstractSimulatedResourceContainer getResourceContainer(String resourceContainerID) {
        assert (this.containsResourceContainer(resourceContainerID));
        return this.resourceContainerHash.get(resourceContainerID);
    }

    public void activateAllActiveResources() {
        ArrayList<AbstractScheduledResource> resources = new ArrayList<AbstractScheduledResource>();
        for (AbstractSimulatedResourceContainer src : this.resourceContainerHash.values()) {
            resources.addAll(src.getActiveResources());
        }
        for (AbstractScheduledResource sar : resources) {
            sar.activateResource();
        }
    }

    public void deactivateAllActiveResources() {
        ArrayList<AbstractScheduledResource> resources = new ArrayList<AbstractScheduledResource>();
        for (AbstractSimulatedResourceContainer src : this.resourceContainerHash.values()) {
            resources.addAll(src.getActiveResources());
        }
        for (AbstractScheduledResource sar : resources) {
            sar.deactivateResource();
        }
    }

    public void deactivateAllPassiveResources() {
    }
}

