/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.simucomframework.ConfidenceStopCondition;
import de.uka.ipd.sdq.simucomframework.MaxMeasurementsStopCondition;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.statistics.IBatchAlgorithm;
import de.uka.ipd.sdq.statistics.PhiMixingBatchAlgorithm;
import de.uka.ipd.sdq.statistics.estimation.IConfidenceEstimator;
import de.uka.ipd.sdq.statistics.estimation.SampleMeanEstimator;
import org.apache.log4j.Logger;

public class ExperimentRunner {
    private static Logger logger = Logger.getLogger((String)ExperimentRunner.class.getName());

    public static double run(SimuComModel model, long simTime) {
        logger.debug((Object)"Setting up experiment runner");
        ExperimentRunner.setupStopConditions(model, simTime);
        double startTime = System.nanoTime();
        model.getSimulationControl().start();
        return (double)System.nanoTime() - startTime;
    }

    private static void setupStopConditions(SimuComModel model, long simTime) {
        if (model.getConfig().getMaxMeasurementsCount() <= 0L && simTime <= 0L) {
            logger.debug((Object)"Deactivating maximum simulation time stop condition per user request");
            model.getSimulationControl().setMaxSimTime(0L);
        } else {
            logger.debug((Object)("Enabling simulation stop condition at maximum simulation time of " + simTime));
            if (simTime > 0L) {
                model.getSimulationControl().setMaxSimTime(simTime);
            }
        }
        model.getSimulationControl().addStopCondition(new MaxMeasurementsStopCondition(model));
        if (model.getConfig().isUseConfidence()) {
            double level = (double)model.getConfig().getConfidenceLevel() / 100.0;
            double halfWidth = (double)model.getConfig().getConfidenceHalfWidth() / 100.0;
            model.getSimulationControl().addStopCondition(new ConfidenceStopCondition(model, (IBatchAlgorithm)new PhiMixingBatchAlgorithm(), (IConfidenceEstimator)new SampleMeanEstimator(), level, halfWidth));
        }
    }
}

