/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.simucomframework.ResourceRegistry;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.SimProcess;
import de.uka.ipd.sdq.simucomframework.exceptions.ResourceContainerNotFound;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedLinkingResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import java.util.HashMap;

public abstract class Context
extends StackContext {
    private ResourceRegistry registry = null;
    private HashMap<String, AbstractSimulatedResourceContainer> assemblyLinkHash = new HashMap();
    private HashMap<String, IPassiveResource> assemblyPassiveResourceHash = new HashMap();
    private SimProcess myThread = null;
    private SimuComModel myModel = null;

    public Context(SimuComModel myModel) {
        if (myModel != null) {
            this.registry = myModel.getResourceRegistry();
            this.myModel = myModel;
            this.initialiseAssemblyContextLookup();
        } else {
            this.stack.createAndPushNewStackFrame();
        }
    }

    public long getSessionId() {
        return this.myThread.getCurrentSessionId();
    }

    public AbstractSimulatedResourceContainer findResource(String assemblyContextID) {
        AbstractSimulatedResourceContainer container = this.assemblyLinkHash.get(assemblyContextID);
        if (container == null) {
            throw new ResourceContainerNotFound("Resource container for assembly context " + assemblyContextID + " not found. Check your allocation model.");
        }
        return container;
    }

    public SimulatedLinkingResourceContainer findLinkingResource(String linkingResourceContainerID) {
        AbstractSimulatedResourceContainer container = this.registry.getResourceContainer(linkingResourceContainerID);
        if (container == null || !(container instanceof SimulatedLinkingResourceContainer)) {
            throw new ResourceContainerNotFound("Linking resource container for container ID " + linkingResourceContainerID + " not found.");
        }
        return (SimulatedLinkingResourceContainer)container;
    }

    protected void linkAssemblyContextAndResourceContainer(String assemblyContextID, String resourceContainerID) {
        assert (this.registry.containsResourceContainer(resourceContainerID));
        AbstractSimulatedResourceContainer container = this.registry.getResourceContainer(resourceContainerID);
        this.assemblyLinkHash.put(assemblyContextID, container);
    }

    public IPassiveResource getPassiveRessourceInContext(String assemblyContextID, String passiveResourceName, String passiveResourceID, AbstractSimulatedResourceContainer resourceContainer, int capacity) {
        IPassiveResource pr = this.assemblyPassiveResourceHash.get(String.valueOf(assemblyContextID) + passiveResourceID);
        if (pr == null) {
            pr = ((SimulatedResourceContainer)resourceContainer).createPassiveResource(passiveResourceName, String.valueOf(passiveResourceID) + ":" + assemblyContextID, capacity);
            this.assemblyPassiveResourceHash.put(String.valueOf(assemblyContextID) + passiveResourceID, pr);
        }
        return pr;
    }

    protected abstract void initialiseAssemblyContextLookup();

    public SimProcess getThread() {
        return this.myThread;
    }

    public void setSimProcess(SimProcess process) {
        this.myThread = process;
    }

    public SimuComModel getModel() {
        return this.myModel;
    }
}

