/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.probespec.framework.ProbeSpecContext;
import de.uka.ipd.sdq.probespec.framework.calculator.Calculator;
import de.uka.ipd.sdq.probespec.framework.calculator.ICalculatorListener;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.Condition;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.statistics.IBatchAlgorithm;
import de.uka.ipd.sdq.statistics.estimation.ConfidenceInterval;
import de.uka.ipd.sdq.statistics.estimation.IConfidenceEstimator;
import java.util.Vector;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;

public class ConfidenceStopCondition
extends Condition
implements ICalculatorListener {
    private static Logger logger;
    private SimuComModel model;
    private String usageScenarioName;
    private ConfidenceInterval confidence;
    private boolean confidenceReached = false;
    private IBatchAlgorithm batchAlgorithm;
    private IConfidenceEstimator estimator;
    private double confidenceLevel;
    private double halfWidth;
    private int minBatches;

    protected ConfidenceStopCondition(SimuComModel model, IBatchAlgorithm batchAlgorithm, IConfidenceEstimator estimator, double confidenceLevel, double halfWidth) {
        super(model, "Confidence Stop Condition");
        this.model = model;
        this.batchAlgorithm = batchAlgorithm;
        this.estimator = estimator;
        this.confidenceLevel = confidenceLevel;
        this.halfWidth = halfWidth;
        if (model.getConfig().getConfidenceModelElementName() == null) {
            throw new RuntimeException("SimuCom tried to set up a ConfidenceStopCondition, but no usage scenario name was given to measure the confidence for.");
        }
        this.usageScenarioName = model.getConfig().getConfidenceModelElementName();
        this.initialize();
    }

    private void initialize() {
        logger = Logger.getLogger((String)ConfidenceStopCondition.class.getName());
        Calculator c = this.obtainUsageScenarioResponseTimeCalculator(this.usageScenarioName);
        c.addCalculatorListener((ICalculatorListener)this);
        this.minBatches = 0;
    }

    @Override
    public boolean check() {
        return this.confidenceReached;
    }

    public void calculated(Vector<Measure<?, ? extends Quantity>> resultTuple) {
        Measure<?, ? extends Quantity> responseTimeMeasure = resultTuple.get(0);
        double responseTime = responseTimeMeasure.doubleValue((Unit)SI.SECOND);
        this.batchAlgorithm.offerSample(responseTime);
        if (this.batchAlgorithm.hasValidBatches() && this.batchAlgorithm.getBatchMeans().size() >= this.minBatches) {
            ConfidenceInterval ci = this.estimator.estimateConfidence(this.batchAlgorithm.getBatchMeans(), this.confidenceLevel);
            ConfidenceInterval targetCI = new ConfidenceInterval(ci.getMean(), this.halfWidth, this.confidenceLevel);
            if (targetCI.contains(ci)) {
                logger.info((Object)"Requested confidence reached.");
                this.confidenceReached = true;
                this.confidence = ci;
                this.minBatches = this.batchAlgorithm.getBatchMeans().size() + 1;
            } else {
                logger.info((Object)"Requested confidence not yet reached.");
                this.minBatches = this.batchAlgorithm.getBatchMeans().size() + 1;
            }
            logger.info((Object)("Current confidence Inerval: Mean " + ci.getMean() + ", " + this.confidenceLevel * 100.0 + "% Confidence Interval " + "[" + ci.getLowerBound() + "," + ci.getUpperBound() + "]"));
        }
    }

    public ConfidenceInterval getConfidence() {
        return this.confidence;
    }

    private Calculator obtainUsageScenarioResponseTimeCalculator(String usageScenarioName) {
        String calculatorId = usageScenarioName;
        return ProbeSpecContext.instance().getCalculatorRegistry().getCalculatorForId(calculatorId);
    }
}

