/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.probespec.framework.ProbeSpecContext;
import de.uka.ipd.sdq.simucomframework.ExperimentRunner;
import de.uka.ipd.sdq.simucomframework.ISimuComControl;
import de.uka.ipd.sdq.simucomframework.IStatusObserver;
import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import de.uka.ipd.sdq.simucomframework.SimuComFactory;
import de.uka.ipd.sdq.simucomframework.SimuComResult;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.IResourceContainerFactory;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimuComStatus;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimucomstatusFactory;
import de.uka.ipd.sdq.simucomframework.usage.IWorkloadDriver;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractMain
implements ISimuComControl,
BundleActivator {
    private ServiceRegistration serviceRegistryEntry;
    private SimuComModel model = null;
    private SimuComStatus simuComStatus;
    private static Logger logger = Logger.getLogger((String)AbstractMain.class.getName());

    public void start(BundleContext context) throws Exception {
        this.serviceRegistryEntry = context.registerService(ISimuComControl.class.getName(), (Object)this, new Hashtable());
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceRegistryEntry.unregister();
    }

    protected SimuComResult run(final IStatusObserver statusObserver, SimuComConfig config, boolean isRemoteRun) {
        this.initializeLogger(config);
        logger.info((Object)"Starting Simulation");
        final long SIM_STOP_TIME = config.getSimuTime();
        this.model = SimuComFactory.getSimuComModel(config, this.getStatus(), isRemoteRun);
        this.model.initialiseResourceContainer(this.getResourceContainerFactory());
        this.model.setUsageScenarios(this.getWorkloads());
        this.model.getSimulationControl().addTimeObserver(new Observer(){

            @Override
            public void update(Observable clock, Object data) {
                int measurementsPercent;
                int timePercent = (int)(AbstractMain.this.model.getSimulationControl().getCurrentSimulationTime() * 100.0 / (double)SIM_STOP_TIME);
                statusObserver.updateStatus(timePercent < (measurementsPercent = (int)(AbstractMain.this.model.getMainMeasurementsCount() * 100L / AbstractMain.this.model.getConfig().getMaxMeasurementsCount())) ? measurementsPercent : timePercent, AbstractMain.this.model.getSimulationControl().getCurrentSimulationTime(), AbstractMain.this.model.getMainMeasurementsCount());
            }
        });
        this.getStatus().setCurrentSimulationTime(0.0);
        this.setupCalculators();
        double simRealTime = ExperimentRunner.run(this.model, SIM_STOP_TIME);
        ProbeSpecContext.instance().finish();
        logger.info((Object)("Simulation stopped. It took " + simRealTime / Math.pow(10.0, 9.0) + " seconds real time to terminate"));
        this.model.getConfig().getRandomGenerator().dispose();
        return this.model.getErrorStatus();
    }

    private void initializeLogger(SimuComConfig config) {
        Logger simuComLogger = Logger.getLogger((String)"de.uka.ipd.sdq.simucomframework");
        if (config.getVerboseLogging()) {
            simuComLogger.setLevel(Level.ALL);
        } else {
            Level currentLevel = simuComLogger.getEffectiveLevel();
            if (!currentLevel.isGreaterOrEqual((Priority)Level.INFO)) {
                simuComLogger.setLevel(Level.INFO);
            }
        }
        logger.debug((Object)"Extended Simulation Logging enabled!");
        logger.setLevel(Level.INFO);
    }

    protected void stop() {
        ProbeSpecContext.instance().getThreadManager().stopThreads();
        this.model.getSimulationControl().stop();
    }

    protected SimuComModel getModel() {
        return this.model;
    }

    @Override
    public Throwable getErrorThrowable() {
        return this.model.getErrorThrowable();
    }

    @Override
    public SimuComResult startSimulation(SimuComConfig config, IStatusObserver observer, boolean isRemoteRun) {
        return this.run(observer, config, isRemoteRun);
    }

    @Override
    public void stopSimulation() {
        this.stop();
    }

    protected abstract IWorkloadDriver[] getWorkloads();

    protected abstract IResourceContainerFactory getResourceContainerFactory();

    protected abstract void setupCalculators();

    @Override
    public SimuComStatus getStatus() {
        if (this.simuComStatus == null) {
            this.simuComStatus = SimucomstatusFactory.eINSTANCE.createSimuComStatus();
            this.simuComStatus.setProcessStatus(SimucomstatusFactory.eINSTANCE.createSimulatedProcesses());
            this.simuComStatus.setResourceStatus(SimucomstatusFactory.eINSTANCE.createSimulatedResources());
        }
        return this.simuComStatus;
    }
}

