/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.stoexvisitor;

import de.uka.ipd.sdq.pcm.parameter.CharacterisedVariable;
import de.uka.ipd.sdq.pcm.stochasticexpressions.PCMStoExPrettyPrintVisitor;
import de.uka.ipd.sdq.pcm.stochasticexpressions.PCMStoExSwitch;
import de.uka.ipd.sdq.simucomframework.variables.EvaluationProxy;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.cache.StoExCache;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.TypesIncompatibleInComparisionException;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.TypesIncompatibleInProductException;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.TypesIncompatibleInTermException;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.ValueNotInFrameException;
import de.uka.ipd.sdq.simucomframework.variables.functions.FunctionLib;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import de.uka.ipd.sdq.simucomframework.variables.stoexvisitor.PCMProbfunctionEvaluationVisitor;
import de.uka.ipd.sdq.simucomframework.variables.stoexvisitor.VariableMode;
import de.uka.ipd.sdq.stoex.BoolLiteral;
import de.uka.ipd.sdq.stoex.BooleanOperatorExpression;
import de.uka.ipd.sdq.stoex.CompareExpression;
import de.uka.ipd.sdq.stoex.DoubleLiteral;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.FunctionLiteral;
import de.uka.ipd.sdq.stoex.IfElseExpression;
import de.uka.ipd.sdq.stoex.IntLiteral;
import de.uka.ipd.sdq.stoex.NegativeExpression;
import de.uka.ipd.sdq.stoex.NotExpression;
import de.uka.ipd.sdq.stoex.Parenthesis;
import de.uka.ipd.sdq.stoex.PowerExpression;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import de.uka.ipd.sdq.stoex.ProductExpression;
import de.uka.ipd.sdq.stoex.StringLiteral;
import de.uka.ipd.sdq.stoex.TermExpression;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class PCMStoExEvaluationVisitor
extends PCMStoExSwitch {
    private static Logger logger = Logger.getLogger((String)PCMStoExEvaluationVisitor.class.getName());
    private PCMProbfunctionEvaluationVisitor probfunctionVisitor;
    private SimulatedStackframe<Object> myStackFrame;
    private ExpressionInferTypeVisitor typeInferer;
    private static PCMStoExPrettyPrintVisitor printVisitor = new PCMStoExPrettyPrintVisitor();
    private static FunctionLib functionLib = null;
    private VariableMode mode;

    public PCMStoExEvaluationVisitor(String stoex, SimulatedStackframe<Object> frame, VariableMode mode) {
        this.myStackFrame = frame;
        this.typeInferer = StoExCache.singleton().getEntry(stoex).getTypeInferer();
        this.mode = mode;
        this.probfunctionVisitor = new PCMProbfunctionEvaluationVisitor(stoex);
        if (functionLib == null) {
            functionLib = new FunctionLib();
        }
    }

    public void setVariableMode(VariableMode mode) {
        this.mode = mode;
    }

    public VariableMode getVariableMode() {
        return this.mode;
    }

    /*
     * Unable to fully structure code
     */
    public Object caseCharacterisedVariable(CharacterisedVariable object) {
        block10: {
            variableID = PCMStoExEvaluationVisitor.printVisitor.caseCharacterisedVariable(object);
            try {
                value = this.myStackFrame.getValue(variableID);
                if (value instanceof EvaluationProxy) {
                    proxy = (EvaluationProxy)value;
                    return StackContext.evaluateStatic(proxy.getStoEx(), proxy.getStackFrame());
                }
                return value;
            }
            catch (ValueNotInFrameException e) {
                if (this.mode == VariableMode.EXCEPTION_ON_NOT_FOUND) {
                    PCMStoExEvaluationVisitor.logger.error((Object)"Value should be in stackframe, but it is not!", (Throwable)e);
                    e.printStackTrace();
                }
                if (this.mode != VariableMode.EXCEPTION_ON_NOT_FOUND) break block10;
                availableIDs = "";
                ** for (e : this.myStackFrame.getContents())
            }
lbl-1000:
            // 1 sources

            {
                availableIDs = String.valueOf(availableIDs) + "<" + e.getKey() + "> ";
                continue;
            }
lbl17:
            // 1 sources

            re = new RuntimeException("Architecture specification incomplete. Stackframe is missing id " + variableID + "\nAvailable IDs are " + availableIDs);
            PCMStoExEvaluationVisitor.logger.error((Object)"Value not found in specification", (Throwable)re);
            throw re;
        }
        if (this.mode == VariableMode.RETURN_NULL_ON_NOT_FOUND) {
            return null;
        }
        if (this.typeInferer.getType((Expression)object) == TypeEnum.INT) {
            return 0;
        }
        if (this.typeInferer.getType((Expression)object) == TypeEnum.DOUBLE) {
            return 0.0;
        }
        if (this.typeInferer.getType((Expression)object) == TypeEnum.ENUM) {
            return "";
        }
        if (this.typeInferer.getType((Expression)object) == TypeEnum.BOOL) {
            return false;
        }
        re = new RuntimeException("Architecture specification incomplete. Stackframe is missing id " + variableID);
        PCMStoExEvaluationVisitor.logger.error((Object)"Value not found in specification", (Throwable)re);
        throw re;
    }

    public Object caseCompareExpression(CompareExpression object) {
        TypeEnum leftType = this.typeInferer.getType((Expression)object.getLeft());
        TypeEnum rightType = this.typeInferer.getType((Expression)object.getRight());
        Object leftExpr = this.doSwitch((EObject)object.getLeft());
        Object rightExpr = this.doSwitch((EObject)object.getRight());
        if (leftType == TypeEnum.ANY) {
            leftType = this.getDynamicType(leftExpr);
        }
        if (leftType == TypeEnum.ANY) {
            rightType = this.getDynamicType(rightExpr);
        }
        if (leftType == TypeEnum.INT && rightType == TypeEnum.DOUBLE) {
            leftExpr = (double)((Integer)leftExpr).intValue();
        }
        if (rightType == TypeEnum.INT && leftType == TypeEnum.DOUBLE) {
            rightExpr = (double)((Integer)rightExpr).intValue();
        }
        if (leftExpr.getClass() != rightExpr.getClass()) {
            throw new TypesIncompatibleInComparisionException("Can not compare " + leftExpr.getClass().getName() + " to " + rightExpr.getClass().getName());
        }
        int result = ((Comparable)leftExpr).compareTo(rightExpr);
        switch (object.getOperation()) {
            case EQUALS: {
                if (result == 0) {
                    return true;
                }
                return false;
            }
            case LESS: {
                if (result < 0) {
                    return true;
                }
                return false;
            }
            case LESSEQUAL: {
                if (result <= 0) {
                    return true;
                }
                return false;
            }
            case GREATER: {
                if (result > 0) {
                    return true;
                }
                return false;
            }
            case GREATEREQUAL: {
                if (result >= 0) {
                    return true;
                }
                return false;
            }
            case NOTEQUAL: {
                if (result != 0) {
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("Unknown Compare Operation found! Should not happen!");
    }

    public Object caseDoubleLiteral(DoubleLiteral object) {
        return object.getValue();
    }

    public Object caseIntLiteral(IntLiteral object) {
        return object.getValue();
    }

    public Object caseStringLiteral(StringLiteral object) {
        return object.getValue();
    }

    public Object caseParenthesis(Parenthesis object) {
        return this.doSwitch((EObject)object.getInnerExpression());
    }

    public Object caseProbabilityFunctionLiteral(ProbabilityFunctionLiteral object) {
        return this.probfunctionVisitor.doSwitch((EObject)object.getFunction_ProbabilityFunctionLiteral());
    }

    public Object caseProductExpression(ProductExpression object) {
        TypeEnum leftType = this.typeInferer.getType((Expression)object.getLeft());
        TypeEnum rightType = this.typeInferer.getType((Expression)object.getRight());
        Object left = this.doSwitch((EObject)object.getLeft());
        Object right = this.doSwitch((EObject)object.getRight());
        if (leftType == TypeEnum.ANY) {
            leftType = this.getDynamicType(left);
        }
        if (leftType == TypeEnum.ANY) {
            rightType = this.getDynamicType(right);
        }
        if (leftType == TypeEnum.INT && rightType == TypeEnum.INT) {
            if (!(left instanceof Integer) || !(right instanceof Integer)) {
                throw new TypesIncompatibleInProductException("Incompatible types in product expression. Expecting Integer!");
            }
            int leftInt = (Integer)left;
            int rightInt = (Integer)right;
            switch (object.getOperation()) {
                case DIV: {
                    return leftInt / rightInt;
                }
                case MULT: {
                    return leftInt * rightInt;
                }
                case MOD: {
                    return leftInt % rightInt;
                }
            }
            throw new RuntimeException("This should never happen!");
        }
        double leftDouble = this.getDouble(left);
        double rightDouble = this.getDouble(right);
        switch (object.getOperation()) {
            case DIV: {
                return leftDouble / rightDouble;
            }
            case MULT: {
                return leftDouble * rightDouble;
            }
            case MOD: {
                return leftDouble % rightDouble;
            }
        }
        throw new RuntimeException("This should never happen!");
    }

    private double getDouble(Object o) {
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        throw new UnsupportedOperationException("Trying to cast a " + o.getClass().getCanonicalName() + " to a Double!");
    }

    private TypeEnum getDynamicType(Object o) {
        if (o instanceof Integer) {
            return TypeEnum.INT;
        }
        if (o instanceof Double) {
            return TypeEnum.DOUBLE;
        }
        if (o instanceof String) {
            return TypeEnum.ENUM;
        }
        if (o instanceof Boolean) {
            return TypeEnum.BOOL;
        }
        throw new RuntimeException("Unknown dynamic type found! Should never happen!");
    }

    public Object caseTermExpression(TermExpression object) {
        TypeEnum leftType = this.typeInferer.getType((Expression)object.getLeft());
        TypeEnum rightType = this.typeInferer.getType((Expression)object.getRight());
        Object left = this.doSwitch((EObject)object.getLeft());
        Object right = this.doSwitch((EObject)object.getRight());
        if (leftType == TypeEnum.ANY) {
            leftType = this.getDynamicType(left);
        }
        if (leftType == TypeEnum.ANY) {
            rightType = this.getDynamicType(right);
        }
        if (leftType == TypeEnum.INT && rightType == TypeEnum.INT) {
            if (!(left instanceof Integer) || !(right instanceof Integer)) {
                throw new TypesIncompatibleInTermException("Incompatible types in term expression. Expecting Integer!");
            }
            int leftInt = (Integer)left;
            int rightInt = (Integer)right;
            switch (object.getOperation()) {
                case ADD: {
                    return leftInt + rightInt;
                }
                case SUB: {
                    return leftInt - rightInt;
                }
            }
            throw new RuntimeException("This should never happen!");
        }
        double leftDouble = this.getDouble(left);
        double rightDouble = this.getDouble(right);
        switch (object.getOperation()) {
            case ADD: {
                return leftDouble + rightDouble;
            }
            case SUB: {
                return leftDouble - rightDouble;
            }
        }
        throw new RuntimeException("This should never happen!");
    }

    public Object caseBooleanOperatorExpression(BooleanOperatorExpression object) {
        boolean b1 = (Boolean)this.doSwitch((EObject)object.getLeft());
        boolean b2 = (Boolean)this.doSwitch((EObject)object.getRight());
        switch (object.getOperation()) {
            case OR: {
                if (!b1 && !b2) {
                    return false;
                }
                return true;
            }
            case AND: {
                if (b1 && b2) {
                    return true;
                }
                return false;
            }
            case XOR: {
                return b1 ^ b2;
            }
        }
        throw new RuntimeException("This should never happen!");
    }

    public Object caseNegativeExpression(NegativeExpression object) {
        Object value = this.doSwitch((EObject)object.getInner());
        if (value instanceof Integer) {
            return -((Integer)value).intValue();
        }
        if (value instanceof Double) {
            return -((Double)value).doubleValue();
        }
        throw new RuntimeException("Type mismatch, unary minus only supported for numbers!");
    }

    public Object caseBoolLiteral(BoolLiteral object) {
        return object.isValue();
    }

    public Object caseNotExpression(NotExpression object) {
        Boolean b = (Boolean)this.doSwitch((EObject)object.getInner());
        return b == false;
    }

    public Object casePowerExpression(PowerExpression object) {
        TypeEnum leftType = this.typeInferer.getType((Expression)object.getBase());
        TypeEnum rightType = this.typeInferer.getType((Expression)object.getExponent());
        Object leftExpr = this.doSwitch((EObject)object.getBase());
        Object rightExpr = this.doSwitch((EObject)object.getExponent());
        if (leftType == TypeEnum.ANY) {
            leftType = this.getDynamicType(leftExpr);
        }
        if (leftType == TypeEnum.ANY) {
            rightType = this.getDynamicType(rightExpr);
        }
        if (leftType == TypeEnum.INT) {
            leftExpr = (double)((Integer)leftExpr).intValue();
        }
        if (rightType == TypeEnum.INT) {
            rightExpr = (double)((Integer)rightExpr).intValue();
        }
        return Math.pow((Double)leftExpr, (Double)rightExpr);
    }

    public Object caseFunctionLiteral(FunctionLiteral object) {
        String functionID = object.getId();
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (Expression e : object.getParameters_FunctionLiteral()) {
            parameterValues.add(this.doSwitch((EObject)e));
        }
        return functionLib.evaluate(functionID, parameterValues);
    }

    public Object caseIfElseExpression(IfElseExpression object) {
        boolean cond = (Boolean)this.doSwitch((EObject)object.getConditionExpression());
        if (cond) {
            return this.doSwitch((EObject)object.getIfExpression());
        }
        return this.doSwitch((EObject)object.getElseExpression());
    }
}

