/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.functions;

import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import de.uka.ipd.sdq.simucomframework.variables.functions.IFunction;
import java.util.List;
import umontreal.iro.lecuyer.probdist.LognormalDist;
import umontreal.iro.lecuyer.probdist.LognormalDistFromMoments;
import umontreal.iro.lecuyer.randvar.LognormalGen;
import umontreal.iro.lecuyer.rng.GenF2w32;
import umontreal.iro.lecuyer.rng.RandomStream;

public class LogNormDistFunctionFromMoments
implements IFunction {
    private RandomStream stream = new GenF2w32();

    @Override
    public boolean checkParameters(List<Object> parameters) {
        if (parameters.size() != 2) {
            return false;
        }
        if (NumberConverter.toDouble(parameters.get(0)) < 0.0) {
            return false;
        }
        return !(NumberConverter.toDouble(parameters.get(1)) < 0.0);
    }

    @Override
    public Object evaluate(List<Object> parameters) {
        double mean = NumberConverter.toDouble(parameters.get(0));
        double stdev = NumberConverter.toDouble(parameters.get(1));
        double variance = stdev * stdev;
        LognormalGen generator = new LognormalGen(this.stream, (LognormalDist)new LognormalDistFromMoments(mean, variance));
        return generator.nextDouble();
    }
}

