/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.functions;

import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import de.uka.ipd.sdq.simucomframework.variables.functions.IFunction;
import java.util.List;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.GammaDistFromMoments;
import umontreal.iro.lecuyer.randvar.GammaGen;
import umontreal.iro.lecuyer.rng.GenF2w32;
import umontreal.iro.lecuyer.rng.RandomStream;

public class GammaDistFunctionFromMoments
implements IFunction {
    private RandomStream stream = new GenF2w32();

    @Override
    public boolean checkParameters(List<Object> parameters) {
        if (parameters.size() != 2) {
            return false;
        }
        if (NumberConverter.toDouble(parameters.get(0)) < 0.0) {
            return false;
        }
        return !(NumberConverter.toDouble(parameters.get(1)) < 0.0);
    }

    @Override
    public Object evaluate(List<Object> parameters) {
        double mean = NumberConverter.toDouble(parameters.get(0));
        double c = NumberConverter.toDouble(parameters.get(1));
        double variance = c * mean * c * mean;
        GammaGen generator = new GammaGen(this.stream, (GammaDist)new GammaDistFromMoments(mean, variance));
        return generator.nextDouble();
    }
}

