/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.functions;

import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import de.uka.ipd.sdq.simucomframework.variables.functions.IFunction;
import java.util.List;
import umontreal.iro.lecuyer.randvar.GammaGen;
import umontreal.iro.lecuyer.rng.GenF2w32;
import umontreal.iro.lecuyer.rng.RandomStream;

public class GammaDistFunction
implements IFunction {
    private RandomStream stream = new GenF2w32();

    @Override
    public boolean checkParameters(List<Object> parameters) {
        if (parameters.size() != 2) {
            return false;
        }
        if (NumberConverter.toDouble(parameters.get(1)) < 0.0) {
            return false;
        }
        return !(NumberConverter.toDouble(parameters.get(0)) < 0.0);
    }

    @Override
    public Object evaluate(List<Object> parameters) {
        double alpha = NumberConverter.toDouble(parameters.get(0));
        double beta = NumberConverter.toDouble(parameters.get(1));
        return GammaGen.nextDouble((RandomStream)this.stream, (double)alpha, (double)beta);
    }
}

