/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.functions;

import de.uka.ipd.sdq.simucomframework.variables.exceptions.FunctionParametersNotAcceptedException;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.FunctionUnknownException;
import de.uka.ipd.sdq.simucomframework.variables.functions.ExpDistFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.GammaDistFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.GammaDistFunctionFromMoments;
import de.uka.ipd.sdq.simucomframework.variables.functions.IFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.LogNormDistFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.LogNormDistFunctionFromMoments;
import de.uka.ipd.sdq.simucomframework.variables.functions.NormDistFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.PoissonDistFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.RoundFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.TruncFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.UniDoubleDistFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.UniIntDistFunction;
import java.util.ArrayList;
import java.util.HashMap;

public class FunctionLib {
    private HashMap<String, IFunction> myFunctions = new HashMap();

    public FunctionLib() {
        this.addStdFunctionsToLib();
    }

    private void addStdFunctionsToLib() {
        this.myFunctions.put("Norm", new NormDistFunction());
        this.myFunctions.put("Exp", new ExpDistFunction());
        this.myFunctions.put("Pois", new PoissonDistFunction());
        this.myFunctions.put("UniDouble", new UniDoubleDistFunction());
        this.myFunctions.put("UniInt", new UniIntDistFunction());
        this.myFunctions.put("Trunc", new TruncFunction());
        this.myFunctions.put("Round", new RoundFunction());
        this.myFunctions.put("Lognorm", new LogNormDistFunction());
        this.myFunctions.put("LognormMoments", new LogNormDistFunctionFromMoments());
        this.myFunctions.put("Gamma", new GammaDistFunction());
        this.myFunctions.put("GammaMoments", new GammaDistFunctionFromMoments());
    }

    public void addFunction(String id, IFunction f) {
        this.myFunctions.put(id, f);
    }

    public Object evaluate(String functionID, ArrayList<Object> parameterValues) {
        if (!this.myFunctions.containsKey(functionID)) {
            throw new FunctionUnknownException("Function " + functionID + " is unknown! Evaluation aborted");
        }
        IFunction f = this.myFunctions.get(functionID);
        if (!f.checkParameters(parameterValues)) {
            throw new FunctionParametersNotAcceptedException("Parameters passed to function " + functionID + " do not match function definition!");
        }
        return f.evaluate(parameterValues);
    }
}

