/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.cache;

import de.uka.ipd.sdq.pcm.stochasticexpressions.parser.PCMStoExLexer;
import de.uka.ipd.sdq.pcm.stochasticexpressions.parser.PCMStoExParser;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunction;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.simucomframework.variables.cache.ProbFunctionCache;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.NonProbabilisticExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.ecore.EObject;

public class StoExCacheEntry {
    private String spec;
    private Expression parsedExpression;
    private ExpressionInferTypeVisitor typeInferer;
    private ProbFunctionCache probFunctionCache;

    public StoExCacheEntry(String spec, IRandomGenerator randomNumberGenerator) {
        this.spec = spec;
        PCMStoExLexer lexer = new PCMStoExLexer((CharStream)new ANTLRStringStream(spec));
        Expression formula = null;
        try {
            formula = new PCMStoExParser((TokenStream)new CommonTokenStream((TokenSource)lexer)).expression();
        }
        catch (RecognitionException e) {
            throw new RuntimeException("Expression not parsable \"" + spec + "\"", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Expression not parsable \"" + spec + "\"", e);
        }
        try {
            this.typeInferer = new NonProbabilisticExpressionInferTypeVisitor();
            this.typeInferer.doSwitch((EObject)formula);
        }
        catch (Exception e) {
            throw new RuntimeException("Expression not parsable \"" + spec + "\"", e);
        }
        this.parsedExpression = formula;
        this.probFunctionCache = new ProbFunctionCache(formula, randomNumberGenerator);
    }

    public Expression getParsedExpression() {
        return this.parsedExpression;
    }

    public String getSpec() {
        return this.spec;
    }

    public ExpressionInferTypeVisitor getTypeInferer() {
        return this.typeInferer;
    }

    public TypeEnum getInferedType(Expression e) {
        return this.typeInferer.getType(e);
    }

    public ProbFunctionCache getProbFunctionCache() {
        return this.probFunctionCache;
    }

    public IProbabilityFunction getProbFunction(EObject e) {
        return this.probFunctionCache.getProbFunction(e);
    }
}

