/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables;

import de.uka.ipd.sdq.simucomframework.variables.EvaluationProxy;
import de.uka.ipd.sdq.simucomframework.variables.cache.StoExCache;
import de.uka.ipd.sdq.simucomframework.variables.cache.StoExCacheEntry;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.StochasticExpressionEvaluationFailedException;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import de.uka.ipd.sdq.simucomframework.variables.stoexvisitor.PCMStoExEvaluationVisitor;
import de.uka.ipd.sdq.simucomframework.variables.stoexvisitor.VariableMode;
import java.io.Serializable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class StackContext
implements Serializable {
    private static final long serialVersionUID = 2031992603442903211L;
    private VariableMode mode = VariableMode.EXCEPTION_ON_NOT_FOUND;
    private static Logger logger = Logger.getLogger((String)StackContext.class.getName());
    protected SimulatedStack<Object> stack = new SimulatedStack();

    public Object evaluate(String string, Class<?> expectedType) {
        return StackContext.evaluateStatic(string, expectedType, this.stack.currentStackFrame(), this.mode);
    }

    public Object evaluate(String string) {
        return StackContext.evaluateStatic(string, this.stack.currentStackFrame(), this.mode);
    }

    public Object evaluate(String stoex, SimulatedStackframe<Object> currentFrame) {
        StoExCacheEntry cacheEntry = StoExCache.singleton().getEntry(stoex);
        Object result = null;
        try {
            result = new PCMStoExEvaluationVisitor(stoex, currentFrame, this.mode).doSwitch((EObject)cacheEntry.getParsedExpression());
        }
        catch (Exception ex) {
            throw new StochasticExpressionEvaluationFailedException("Evaluation of expression " + stoex + " failed.", ex);
        }
        return result;
    }

    public static Object evaluateStatic(String stoex) {
        return StackContext.evaluateStatic(stoex, new SimulatedStackframe<Object>());
    }

    public static Object evaluateStatic(String stoex, SimulatedStackframe<Object> currentFrame) {
        StoExCacheEntry cacheEntry = StoExCache.singleton().getEntry(stoex);
        Object result = null;
        try {
            result = new PCMStoExEvaluationVisitor(stoex, currentFrame, VariableMode.EXCEPTION_ON_NOT_FOUND).doSwitch((EObject)cacheEntry.getParsedExpression());
        }
        catch (Exception ex) {
            throw new StochasticExpressionEvaluationFailedException("Evaluation of expression " + stoex + " failed.", ex);
        }
        return result;
    }

    public static Object evaluateStatic(String stoex, SimulatedStackframe<Object> currentFrame, VariableMode mode) {
        StoExCacheEntry cacheEntry = StoExCache.singleton().getEntry(stoex);
        Object result = null;
        try {
            result = new PCMStoExEvaluationVisitor(stoex, currentFrame, mode).doSwitch((EObject)cacheEntry.getParsedExpression());
        }
        catch (Exception ex) {
            throw new StochasticExpressionEvaluationFailedException("Evaluation of expression " + stoex + " failed.", ex);
        }
        return result;
    }

    public static Object evaluateStatic(String string, Class<?> expectedType) {
        return StackContext.evaluateStatic(string, expectedType, new SimulatedStackframe<Object>(), VariableMode.EXCEPTION_ON_NOT_FOUND);
    }

    public static Object evaluateStatic(String string, Class<?> expectedType, SimulatedStackframe<Object> frame) {
        return StackContext.evaluateStatic(string, expectedType, frame, VariableMode.EXCEPTION_ON_NOT_FOUND);
    }

    public static Object evaluateStatic(String string, Class<?> expectedType, SimulatedStackframe<Object> frame, VariableMode mode) {
        logger.debug((Object)("About to evaluate " + string));
        Object result = StackContext.evaluateStatic(string, frame, mode);
        logger.debug((Object)("Result " + result));
        if (expectedType.isInstance(result)) {
            return result;
        }
        if (expectedType == Byte.class && result.getClass() == Character.class) {
            return (byte)((Character)result).charValue();
        }
        if (expectedType == Character.class && result.getClass() == Byte.class) {
            return Character.valueOf((char)((Byte)result).byteValue());
        }
        if (expectedType == Short.class) {
            if (result.getClass() == Byte.class) {
                return ((Byte)result).shortValue();
            }
            if (result.getClass() == Character.class) {
                return Byte.valueOf((byte)((Character)result).charValue()).shortValue();
            }
        }
        if (expectedType == Integer.class) {
            if (result.getClass() == Byte.class) {
                return ((Byte)result).intValue();
            }
            if (result.getClass() == Short.class) {
                return ((Short)result).intValue();
            }
            if (result.getClass() == Character.class) {
                return Byte.valueOf((byte)((Character)result).charValue()).intValue();
            }
        }
        if (expectedType == Long.class) {
            if (result.getClass() == Byte.class) {
                return ((Byte)result).longValue();
            }
            if (result.getClass() == Short.class) {
                return ((Short)result).longValue();
            }
            if (result.getClass() == Integer.class) {
                return ((Integer)result).longValue();
            }
            if (result.getClass() == Character.class) {
                return Byte.valueOf((byte)((Character)result).charValue()).longValue();
            }
        }
        if (expectedType == Float.class) {
            if (result.getClass() == Byte.class) {
                return Float.valueOf(((Byte)result).floatValue());
            }
            if (result.getClass() == Short.class) {
                return Float.valueOf(((Short)result).floatValue());
            }
            if (result.getClass() == Integer.class) {
                return Float.valueOf(((Integer)result).floatValue());
            }
            if (result.getClass() == Long.class) {
                return Float.valueOf(((Long)result).floatValue());
            }
            if (result.getClass() == Character.class) {
                return Float.valueOf(Byte.valueOf((byte)((Character)result).charValue()).floatValue());
            }
        }
        if (expectedType == Double.class) {
            if (result.getClass() == Byte.class) {
                return ((Byte)result).doubleValue();
            }
            if (result.getClass() == Short.class) {
                return ((Short)result).doubleValue();
            }
            if (result.getClass() == Integer.class) {
                return ((Integer)result).doubleValue();
            }
            if (result.getClass() == Long.class) {
                return ((Long)result).doubleValue();
            }
            if (result.getClass() == Float.class) {
                return ((Float)result).doubleValue();
            }
            if (result.getClass() == Character.class) {
                return Byte.valueOf((byte)((Character)result).charValue()).doubleValue();
            }
        }
        UnsupportedOperationException ex = new UnsupportedOperationException("Evaluation result is of type " + result.getClass().getCanonicalName() + " but expected was " + expectedType.getCanonicalName() + " and no conversion was available...");
        logger.error((Object)"Evaluation of an expression resulted in wrong type!", (Throwable)ex);
        throw ex;
    }

    public void evaluateInner(SimulatedStackframe<Object> frame, String variablename) {
        SimulatedStackframe<Object> topmostFrame = this.getStack().currentStackFrame();
        for (Map.Entry entry : topmostFrame.getContents()) {
            if (!((String)entry.getKey()).startsWith(variablename) || !(entry.getValue() instanceof EvaluationProxy)) continue;
            EvaluationProxy proxy = (EvaluationProxy)entry.getValue();
            Object result = StackContext.evaluateStatic(proxy.getStoEx(), proxy.getStackFrame(), this.mode);
            frame.addValue((String)entry.getKey(), result);
        }
    }

    public SimulatedStack<Object> getStack() {
        return this.stack;
    }

    public VariableMode getEvaluationMode() {
        return this.mode;
    }

    public void setEvaluationMode(VariableMode mode) {
        this.mode = mode;
    }
}

