/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.tests;

import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.StochasticExpressionEvaluationFailedException;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import de.uka.ipd.sdq.simucomframework.variables.stoexvisitor.VariableMode;
import de.uka.ipd.sdq.simucomframework.variables.tests.StoExVisitorTests;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class StoExVisitorVariablesTest
extends TestCase {
    private static Logger logger = Logger.getLogger((String)StoExVisitorTests.class.getName());
    private SimulatedStackframe<Object> stackFrame;

    public void setUp() {
        PatternLayout myLayout = new PatternLayout("%d{HH:mm:ss,SSS} [%t] %-5p %m [%c]%n");
        ConsoleAppender ca = new ConsoleAppender((Layout)myLayout);
        ca.setThreshold(Priority.INFO);
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)ca);
        this.stackFrame = new SimulatedStackframe();
        this.stackFrame.addValue("anInt.BYTESIZE", (Object)10);
        this.stackFrame.addValue("anBoolean.VALUE", (Object)false);
        this.stackFrame.addValue("anDouble.VALUE", (Object)10.0);
    }

    public void testStackEvaluate() {
        int i = (Integer)StackContext.evaluateStatic((String)"anInt.BYTESIZE", this.stackFrame);
        Assert.assertEquals((int)i, (int)10);
        boolean b = (Boolean)StackContext.evaluateStatic((String)"anBoolean.VALUE", this.stackFrame);
        Assert.assertEquals((boolean)b, (boolean)false);
        double d = (Double)StackContext.evaluateStatic((String)"anDouble.VALUE", this.stackFrame);
        Assert.assertEquals((Object)d, (Object)10.0);
    }

    public void testStackEvaluateAutoTypeConversion() {
        SimulatedStackframe stackFrame = new SimulatedStackframe();
        String CHAR_VALUE = "c.VALUE";
        String BYTE_VALUE = "b.VALUE";
        String SHORT_VALUE = "s.VALUE";
        String INTEGER_VALUE = "i.VALUE";
        String LONG_VALUE = "l.VALUE";
        String FLOAT_VALUE = "f.VALUE";
        String DOUBLE_VALUE = "d.VALUE";
        char c = '\u000e';
        stackFrame.addValue(CHAR_VALUE, (Object)Character.valueOf(c));
        byte b = 15;
        stackFrame.addValue(BYTE_VALUE, (Object)b);
        short s = 16;
        stackFrame.addValue(SHORT_VALUE, (Object)s);
        int i = 17;
        stackFrame.addValue(INTEGER_VALUE, (Object)i);
        long l = 18L;
        stackFrame.addValue(LONG_VALUE, (Object)l);
        float f = 19.0f;
        stackFrame.addValue(FLOAT_VALUE, (Object)Float.valueOf(f));
        double d = 20.0;
        stackFrame.addValue(DOUBLE_VALUE, (Object)d);
        Assert.assertEquals((Object)((byte)c), (Object)StackContext.evaluateStatic((String)CHAR_VALUE, Byte.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Character.valueOf((char)b), (Object)StackContext.evaluateStatic((String)BYTE_VALUE, Character.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Byte.valueOf(b).shortValue(), (Object)StackContext.evaluateStatic((String)BYTE_VALUE, Short.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Byte.valueOf((byte)Character.valueOf(c).charValue()).shortValue(), (Object)StackContext.evaluateStatic((String)CHAR_VALUE, Short.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Byte.valueOf(b).intValue(), (Object)StackContext.evaluateStatic((String)BYTE_VALUE, Integer.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Byte.valueOf((byte)Character.valueOf(c).charValue()).intValue(), (Object)StackContext.evaluateStatic((String)CHAR_VALUE, Integer.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Short.valueOf(s).intValue(), (Object)StackContext.evaluateStatic((String)SHORT_VALUE, Integer.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Byte.valueOf(b).longValue(), (Object)StackContext.evaluateStatic((String)BYTE_VALUE, Long.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Byte.valueOf((byte)Character.valueOf(c).charValue()).longValue(), (Object)StackContext.evaluateStatic((String)CHAR_VALUE, Long.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Short.valueOf(s).longValue(), (Object)StackContext.evaluateStatic((String)SHORT_VALUE, Long.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Integer.valueOf(i).longValue(), (Object)StackContext.evaluateStatic((String)INTEGER_VALUE, Long.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Float.valueOf(Byte.valueOf(b).floatValue()), (Object)StackContext.evaluateStatic((String)BYTE_VALUE, Float.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Float.valueOf(Byte.valueOf((byte)Character.valueOf(c).charValue()).floatValue()), (Object)StackContext.evaluateStatic((String)CHAR_VALUE, Float.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Float.valueOf(Short.valueOf(s).floatValue()), (Object)StackContext.evaluateStatic((String)SHORT_VALUE, Float.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Float.valueOf(Integer.valueOf(i).floatValue()), (Object)StackContext.evaluateStatic((String)INTEGER_VALUE, Float.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Float.valueOf(Long.valueOf(l).floatValue()), (Object)StackContext.evaluateStatic((String)LONG_VALUE, Float.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Byte.valueOf(b).doubleValue(), (Object)StackContext.evaluateStatic((String)BYTE_VALUE, Double.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Byte.valueOf((byte)Character.valueOf(c).charValue()).doubleValue(), (Object)StackContext.evaluateStatic((String)CHAR_VALUE, Double.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Short.valueOf(s).doubleValue(), (Object)StackContext.evaluateStatic((String)SHORT_VALUE, Double.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Integer.valueOf(i).doubleValue(), (Object)StackContext.evaluateStatic((String)INTEGER_VALUE, Double.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Long.valueOf(l).doubleValue(), (Object)StackContext.evaluateStatic((String)LONG_VALUE, Double.class, (SimulatedStackframe)stackFrame));
        Assert.assertEquals((Object)Float.valueOf(f).doubleValue(), (Object)StackContext.evaluateStatic((String)FLOAT_VALUE, Double.class, (SimulatedStackframe)stackFrame));
    }

    public void testInvalidAccess() {
        try {
            StackContext.evaluateStatic((String)"sssdffg.VALUE", this.stackFrame);
        }
        catch (Exception ex) {
            Assert.assertEquals(StochasticExpressionEvaluationFailedException.class, ex.getClass());
            return;
        }
        Assert.fail((String)"Parser error expected, but did not occur");
    }

    public void testPowVar() {
        double result3 = (Double)StackContext.evaluateStatic((String)"10^(anInt.BYTESIZE)", this.stackFrame);
        Assert.assertEquals((Object)Math.pow(10.0, 10.0), (Object)result3);
    }

    public void testReturnDefault() {
        int bs = (Integer)StackContext.evaluateStatic((String)"a.BYTESIZE", this.stackFrame, (VariableMode)VariableMode.RETURN_DEFAULT_ON_NOT_FOUND);
        Assert.assertEquals((int)bs, (int)0);
    }
}

