/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.tests;

import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.simucomframework.SimuComDefaultRandomNumberGenerator;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.cache.StoExCache;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class StoExVisitorTests
extends TestCase {
    private static Logger logger = Logger.getLogger((String)StoExVisitorTests.class.getName());

    public void setUp() {
        StoExCache.initialiseStoExCache((IRandomGenerator)new SimuComDefaultRandomNumberGenerator(new long[]{1L, 2L, 3L, 4L, 5L, 6L}));
        PatternLayout myLayout = new PatternLayout("%d{HH:mm:ss,SSS} [%t] %-5p %m [%c]%n");
        ConsoleAppender ca = new ConsoleAppender((Layout)myLayout);
        ca.setThreshold(Priority.INFO);
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)ca);
    }

    public void testDoubleOperations() {
        logger.debug((Object)"Running Double Op Test");
        int i = 0;
        while (i < 2000) {
            double result = (Double)StackContext.evaluateStatic((String)"( ( DoublePDF[ (1.0; 0.02236114450589084) (2.0; 0.04664582832411637) (3.0; 0.10387112286607357) (4.0; 0.1606155325799471) (5.0; 0.20389516710747776) (6.0; 0.18826641019475834) (7.0; 0.11372926184178889) (8.0; 0.06852608800192354) (9.0; 0.02933397451310411) (10.0; 0.017311853811012263) (11.0; 0.009377254147631643) (12.0; 0.008896369319547967) (13.0; 0.004327963452753066) (14.0; 0.005049290694878576) (15.0; 0.0019235393123346958) (16.0; 0.002163981726376533) (17.0; 0.0012022120702091848) ] * 0.04 ) + 0.18 ) * 14");
            Assert.assertTrue((String)("Result must be greater 0, but was " + result), (result >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((result <= 12.1 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testUnaryOperator() {
        int result = (Integer)StackContext.evaluateStatic((String)"-4");
        Assert.assertEquals((int)-4, (int)result);
        boolean result2 = (Boolean)StackContext.evaluateStatic((String)"NOT true");
        Assert.assertEquals((boolean)result2, (boolean)false);
    }

    public void testPow1() {
        double result3 = (Double)StackContext.evaluateStatic((String)"10^3");
        Assert.assertEquals((Object)1000.0, (Object)result3);
    }

    public void testPow2() {
        double result3 = (Double)StackContext.evaluateStatic((String)"10^-3");
        Assert.assertEquals((Object)0.001, (Object)result3);
    }

    public void testDouble() {
        double result3 = (Double)StackContext.evaluateStatic((String)"1.0E-3");
        Assert.assertEquals((Object)0.001, (Object)result3);
        result3 = (Double)StackContext.evaluateStatic((String)"0.4 + 0.6");
        Assert.assertEquals((Object)1.0, (Object)result3);
        result3 = (Double)StackContext.evaluateStatic((String)"5 * 10.0");
        Assert.assertEquals((Object)50.0, (Object)result3);
        result3 = (Double)StackContext.evaluateStatic((String)"20.0 / 10");
        Assert.assertEquals((Object)2.0, (Object)result3);
        result3 = (Double)StackContext.evaluateStatic((String)"4.0^0.5");
        Assert.assertEquals((Object)2.0, (Object)result3);
    }

    public void testIntegerDivisionSemantics() {
        double i = 25.0;
        double result3 = ((Integer)StackContext.evaluateStatic((String)"25 + 15 * 10 / 1000")).intValue();
        Assert.assertEquals((Object)result3, (Object)i);
        i = 25.15;
        result3 = (Double)StackContext.evaluateStatic((String)"25 + 15 * 10 / 1000.0");
        Assert.assertEquals((Object)result3, (Object)i);
        Assert.assertEquals((Object)result3, (Object)25.15);
    }

    public void testBool() {
        boolean result = (Boolean)StackContext.evaluateStatic((String)"true");
        Assert.assertEquals((boolean)true, (boolean)result);
        result = (Boolean)StackContext.evaluateStatic((String)"5 > 4");
        Assert.assertEquals((boolean)true, (boolean)result);
        result = (Boolean)StackContext.evaluateStatic((String)"NOT (5 <= 4)");
        Assert.assertEquals((boolean)true, (boolean)result);
        result = (Boolean)StackContext.evaluateStatic((String)"true AND false");
        Assert.assertEquals((boolean)false, (boolean)result);
        result = (Boolean)StackContext.evaluateStatic((String)"true AND true");
        Assert.assertEquals((boolean)true, (boolean)result);
        result = (Boolean)StackContext.evaluateStatic((String)"true OR false");
        Assert.assertEquals((boolean)true, (boolean)result);
        result = (Boolean)StackContext.evaluateStatic((String)"true XOR true");
        Assert.assertEquals((boolean)false, (boolean)result);
    }

    public void testFunctions() {
        double result3;
        logger.info((Object)"UniDouble");
        int i = 0;
        while (i < 2000) {
            result3 = (Double)StackContext.evaluateStatic((String)"UniDouble(1,4)");
            Assert.assertTrue((result3 >= 1.0 && result3 <= 4.0 ? 1 : 0) != 0);
            ++i;
        }
        logger.info((Object)"UniInt");
        i = 0;
        while (i < 2000) {
            int result32 = (Integer)StackContext.evaluateStatic((String)"UniInt(1,4)");
            Assert.assertTrue((result32 >= 1 && result32 <= 4 ? 1 : 0) != 0);
            ++i;
        }
        logger.info((Object)"Norm");
        i = 0;
        while (i < 200) {
            result3 = (Double)StackContext.evaluateStatic((String)"Norm(0,1)");
            logger.debug((Object)result3);
            Assert.assertTrue((result3 >= -5.0 && result3 <= 5.0 ? 1 : 0) != 0);
            ++i;
        }
        logger.info((Object)"Exp");
        i = 0;
        while (i < 200) {
            result3 = (Double)StackContext.evaluateStatic((String)"Exp(1)");
            Assert.assertTrue((result3 >= 0.0 ? 1 : 0) != 0);
            ++i;
        }
        logger.info((Object)"Trunc");
        int result4 = (Integer)StackContext.evaluateStatic((String)"Trunc(2.5)");
        Assert.assertEquals((int)2, (int)result4);
        result4 = (Integer)StackContext.evaluateStatic((String)"Trunc(2)");
        Assert.assertEquals((int)2, (int)result4);
        logger.info((Object)"Round");
        result4 = (Integer)StackContext.evaluateStatic((String)"Round(2.5)");
        Assert.assertEquals((int)3, (int)result4);
        result4 = (Integer)StackContext.evaluateStatic((String)"Round(3)");
        Assert.assertEquals((int)3, (int)result4);
    }

    public void testIfelse() {
        int result = (Integer)StackContext.evaluateStatic((String)"true ? 3 : 4");
        Assert.assertEquals((int)3, (int)result);
        result = (Integer)StackContext.evaluateStatic((String)"false ? 3 : 4");
        Assert.assertEquals((int)4, (int)result);
    }
}

