/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.ssj;

import de.uka.ipd.sdq.simucomframework.ssj.ISimProcessStrategy;
import java.util.concurrent.Semaphore;

public class SimProcessThreadingStrategy
implements ISimProcessStrategy {
    private Thread myThread = null;
    Semaphore waitingSemaphore = new Semaphore(0);
    Semaphore waitingForSuspendSemaphore = new Semaphore(0);

    @Override
    public void startProcess(Runnable myRunnable) {
        this.myThread = new Thread(myRunnable);
        this.myThread.start();
        this.waitingForSuspendSemaphore.acquireUninterruptibly();
    }

    @Override
    public void resumeProcess() {
        this.waitingSemaphore.release();
        this.waitingForSuspendSemaphore.acquireUninterruptibly();
    }

    @Override
    public void finishProcess() {
        this.waitingForSuspendSemaphore.release();
    }

    @Override
    public void suspendProcess() {
        this.waitingForSuspendSemaphore.release();
        this.waitingSemaphore.acquireUninterruptibly();
    }
}

