/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.ssj;

import de.uka.ipd.sdq.simucomframework.abstractSimEngine.ISimProcessDelegate;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.SimProcess;
import de.uka.ipd.sdq.simucomframework.ssj.ISimProcessStrategy;
import de.uka.ipd.sdq.simucomframework.ssj.ProcessState;
import de.uka.ipd.sdq.simucomframework.ssj.SSJExperiment;
import de.uka.ipd.sdq.simucomframework.ssj.SimProcessThreadingStrategy;
import org.apache.log4j.Logger;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Simulator;

public class SSJSimProcess
implements ISimProcessDelegate {
    private static Logger logger = Logger.getLogger((String)SSJSimProcess.class.getName());
    private SimProcess myAbstractProcess = null;
    private ProcessState myProcessState = ProcessState.READY;
    private ISimProcessStrategy processStrategy = new SimProcessThreadingStrategy();
    private Simulator sim;

    public SSJSimProcess(SimProcess myProcess, String name) {
        this.sim = ((SSJExperiment)myProcess.getModel().getSimulationControl()).getSimulator();
        this.myAbstractProcess = myProcess;
        Runnable myRunnable = new Runnable(){

            @Override
            public void run() {
                logger.debug((Object)("Starting sim process [ID: " + SSJSimProcess.this.myAbstractProcess.getId() + "]"));
                SSJSimProcess.this.actions();
                SSJSimProcess.this.processStrategy = null;
            }
        };
        this.processStrategy.startProcess(myRunnable);
    }

    public void scheduleAt(double delay) {
        if (this.myProcessState != ProcessState.SUSPENDED && !this.isTerminated()) {
            throw new IllegalStateException("Tried to schedule thread which was not suspended [" + this.myAbstractProcess.getId() + "]");
        }
        if (!this.simIsRunning() && !this.isTerminated()) {
            this.resume();
        }
        if (!this.isTerminated()) {
            new Event(this.sim){

                public void actions() {
                    if (SSJSimProcess.this.myProcessState != ProcessState.TERMINATED) {
                        SSJSimProcess.this.resume();
                    }
                }
            }.schedule(delay);
        }
    }

    private boolean simIsRunning() {
        return ((SSJExperiment)this.myAbstractProcess.getModel().getSimulationControl()).isRunning();
    }

    public void actions() {
        this.myProcessState = ProcessState.RUNNING;
        this.suspend();
        this.myAbstractProcess.lifeCycle();
        this.myProcessState = ProcessState.TERMINATED;
        this.processStrategy.finishProcess();
    }

    public boolean isTerminated() {
        return this.myProcessState == ProcessState.TERMINATED;
    }

    public void passivate() {
        this.suspend();
    }

    private void suspend() {
        if (this.myProcessState != ProcessState.RUNNING) {
            throw new IllegalStateException("Tried to suspend non-running process [" + this.myAbstractProcess.getId() + "]");
        }
        logger.debug((Object)("Suspending thread [" + this.myAbstractProcess.getId() + "]"));
        this.myProcessState = ProcessState.SUSPENDED;
        this.processStrategy.suspendProcess();
    }

    private void resume() {
        if (this.myProcessState != ProcessState.SUSPENDED) {
            throw new IllegalStateException("Tried to resume thread which was not suspended [" + this.myAbstractProcess.getId() + "]");
        }
        logger.debug((Object)("Resuming thread [" + this.myAbstractProcess.getId() + "]"));
        this.myProcessState = ProcessState.RUNNING;
        this.processStrategy.resumeProcess();
    }
}

