/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.ssj;

import de.uka.ipd.sdq.scheduler.ISchedulingFactory;
import de.uka.ipd.sdq.scheduler.factory.SchedulingFactory;
import de.uka.ipd.sdq.scheduler.resources.active.AbstractActiveResource;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.Condition;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.ISimulationControlDelegate;
import de.uka.ipd.sdq.simucomframework.exceptions.FailureStatistics;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import java.util.ArrayList;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Simulator;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.simevents.eventlist.SplayTree;

public class SSJExperiment
implements ISimulationControlDelegate {
    private Simulator simulator;
    private ArrayList<Condition> stopConditions = new ArrayList();
    private ArrayList<Observer> timeObservers = new ArrayList();
    double lastNotificationTime = 0.0;
    private AtomicBoolean isRunning = new AtomicBoolean();
    private SimuComModel model;
    protected static Logger logger = Logger.getLogger((String)SSJExperiment.class.getName());

    public SSJExperiment(SimuComModel model) {
        model.setSimulationControl((ISimulationControlDelegate)this);
        this.simulator = new Simulator();
        this.simulator.init((EventList)new SplayTree());
        SchedulingFactory.setUsedSimulator((Simulator)this.simulator);
        ISchedulingFactory.eINSTANCE.resetFactory();
        this.model = model;
        this.createStartEvent(model).schedule(0.0);
        this.createCheckEvent(model).schedule(1.0);
    }

    public void addStopCondition(Condition condition) {
        this.stopConditions.add(condition);
    }

    public void checkStopConditions() {
        if (this.lastNotificationTime != this.getCurrentSimulationTime()) {
            this.lastNotificationTime = this.getCurrentSimulationTime();
            for (Observer o : this.timeObservers) {
                o.update(null, this.lastNotificationTime);
            }
        }
        for (Condition c : this.stopConditions) {
            if (!c.check()) continue;
            this.createStopEvent().schedule(0.0);
            return;
        }
    }

    public void addTimeObserver(Observer observer) {
        this.timeObservers.add(observer);
    }

    public double getCurrentSimulationTime() {
        return this.simulator.time();
    }

    public void setMaxSimTime(long simTime) {
        this.createStopEvent().schedule((double)simTime);
    }

    public void start() {
        this.isRunning.set(true);
        double start = System.nanoTime();
        logger.warn((Object)"Starting simulation...");
        this.simulator.start();
        logger.warn((Object)("Simulation terminated. Took " + ((double)System.nanoTime() - start) / Math.pow(10.0, 9.0) + " real time seconds."));
    }

    public void stop() {
        if (this.isRunning.compareAndSet(true, false)) {
            logger.info((Object)"Simulation stop requested!");
            this.simulator.stop();
            this.model.getResourceRegistry().deactivateAllActiveResources();
            this.model.getResourceRegistry().deactivateAllPassiveResources();
            logger.info((Object)("Simulation took " + this.model.getSimulationControl().getCurrentSimulationTime() + " simulation seconds"));
            AbstractActiveResource.cleanProcesses();
            if (this.model.getConfig().getSimulateFailures()) {
                FailureStatistics.getInstance().printFailureStatistics(logger);
            }
        }
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    private Event createStopEvent() {
        return new Event(this.simulator){

            public void actions() {
                if (SSJExperiment.this.isRunning()) {
                    logger.debug((Object)"Executing Stop Event");
                    SSJExperiment.this.stop();
                }
            }
        };
    }

    private Event createStartEvent(final SimuComModel model) {
        return new Event(this.simulator){

            public void actions() {
                logger.debug((Object)"Executing Initial Event");
                model.doInitialSchedules();
            }
        };
    }

    private Event createCheckEvent(final SimuComModel model) {
        return new Event(this.simulator){

            public void actions() {
                SSJExperiment.this.checkStopConditions();
                if (model.getSimulationControl().isRunning()) {
                    this.schedule(1.0);
                }
            }
        };
    }
}

