/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.simulationdock;

import de.uka.ipd.sdq.simucomframework.IStatusObserver;
import de.uka.ipd.sdq.simucomframework.simulationdock.SimulationDockService;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class DebugObserver
implements IStatusObserver {
    protected static Logger logger = Logger.getLogger((String)DebugObserver.class.getName());
    private boolean isStepping;
    private EventAdmin eventAdmin;
    private SimulationDockService myDock;
    private Object suspendedBarrier = new Object();
    private boolean suspended;

    public DebugObserver(EventAdmin eventAdmin, SimulationDockService myDock) {
        this.eventAdmin = eventAdmin;
        this.myDock = myDock;
        this.suspended = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        this.suspended = true;
        Object object = this.suspendedBarrier;
        synchronized (object) {
            this.suspendedBarrier.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.suspended = false;
        this.postEvent("de/uka/ipd/sdq/simucomframework/simucomdock/SIM_RESUMED");
        if (this.isStepping) {
            this.isStepping = false;
            this.postEvent("de/uka/ipd/sdq/simucomframework/simucomdock/PERFORMED_STEP");
        }
        Object object = this.suspendedBarrier;
        synchronized (object) {
            this.suspendedBarrier.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void step() {
        if (this.suspended && !this.isStepping) {
            this.isStepping = true;
            this.postEvent("de/uka/ipd/sdq/simucomframework/simucomdock/STARTED_STEP");
            Object object = this.suspendedBarrier;
            synchronized (object) {
                this.suspendedBarrier.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateStatus(int percentDone, double currentSimTime, long measurementsTaken) {
        if (this.isStepping) {
            this.isStepping = false;
            this.postEvent("de/uka/ipd/sdq/simucomframework/simucomdock/PERFORMED_STEP");
        }
        Object object = this.suspendedBarrier;
        synchronized (object) {
            while (this.suspended && !this.isStepping) {
                try {
                    this.postEvent("de/uka/ipd/sdq/simucomframework/simucomdock/SIM_SUSPENDED");
                    this.suspendedBarrier.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.suspended) {
            this.postEvent("de/uka/ipd/sdq/simucomframework/simucomdock/SIM_RESUMED");
            logger.debug((Object)"------------------------- Simulation Resumed ----------------------------------");
        }
    }

    private void postEvent(String topic) {
        this.postEvent(topic, new Hashtable<String, Object>());
    }

    private void postEvent(String topic, Hashtable<String, Object> newProperties) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("DOCK_ID", this.myDock.getDockId());
        properties.putAll(newProperties);
        Event event = new Event(topic, properties);
        this.eventAdmin.sendEvent(event);
    }
}

