/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.desmoj;

import de.uka.ipd.sdq.simucomframework.abstractSimEngine.Condition;
import de.uka.ipd.sdq.simucomframework.abstractSimEngine.ISimulationControlDelegate;
import de.uka.ipd.sdq.simucomframework.desmoj.DesmoJModel;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import desmoj.core.simulator.Entity;
import desmoj.core.simulator.Event;
import desmoj.core.simulator.Model;
import desmoj.core.simulator.SimTime;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;

public class DesmoJExperiment
implements ISimulationControlDelegate {
    private DesmoJModel model;
    private boolean isRunning;
    private SimuComModel simuComModel;
    private ArrayList<Condition> stopConditions = new ArrayList();
    double lastStopConditionEvaluationSimTime = 0.0;
    protected static Logger logger = Logger.getLogger((String)DesmoJExperiment.class.getName());

    public DesmoJExperiment(SimuComModel model) {
        this.model = new DesmoJModel(model);
        this.simuComModel = model;
    }

    public void addStopCondition(Condition condition) {
        this.stopConditions.add(condition);
    }

    public void checkStopConditions() {
        if (this.lastStopConditionEvaluationSimTime < this.getCurrentSimulationTime()) {
            if (this.isRunning()) {
                Entity e = new Entity(this.model, "StopEntity", false){};
                for (Condition c : this.stopConditions) {
                    if (!c.check()) continue;
                    logger.debug((Object)"Scheduling stop event as a stop condition is true.");
                    this.createStopCondition().schedule(e, new SimTime(0.0));
                    return;
                }
            }
            this.lastStopConditionEvaluationSimTime = this.getCurrentSimulationTime();
        }
    }

    private Event createStopCondition() {
        return new Event(this.model, "StopEvent", false){

            public void eventRoutine(Entity arg0) {
                logger.debug((Object)"createStopCondition()::eventRountine(..) reached.");
                DesmoJExperiment.this.stop();
            }
        };
    }

    public void addTimeObserver(Observer observer) {
        this.model.getExperiment().getSimClock().addObserver(observer);
    }

    public double getCurrentSimulationTime() {
        return this.model.currentTime().getTimeValue();
    }

    public void setMaxSimTime(long simTime) {
        if (simTime > 0L) {
            Entity e = new Entity(this.model, "StopEntity", false){};
            this.createStopCondition().schedule(e, new SimTime((double)simTime));
        }
    }

    public void start() {
        this.isRunning = true;
        this.addTimeObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                DesmoJExperiment.this.checkStopConditions();
            }
        });
        double start = System.nanoTime();
        logger.warn((Object)"Starting simulation...");
        this.model.getExperiment().start();
        logger.warn((Object)("Simulation terminated. Took " + ((double)System.nanoTime() - start) / Math.pow(10.0, 9.0) + " real time seconds."));
        this.isRunning = false;
    }

    public void stop() {
        if (this.isRunning) {
            this.isRunning = false;
            logger.info((Object)"Simulation stop requested!");
            this.simuComModel.getResourceRegistry().deactivateAllActiveResources();
            this.simuComModel.getResourceRegistry().deactivateAllPassiveResources();
            logger.info((Object)"Scheduled Simulation Stop Event now");
        }
    }

    public Model getDesmoJModel() {
        return this.model;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

