/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.util;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.dao.IExperimentDAO;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

public class ExperimentManager {
    public static final double SCALING_FACTOR = 1000000.0;
    private Hashtable<String, TimeSpanSensor> timeSpanSensorHash = new Hashtable();
    private Experiment experiment;
    private ExperimentRun run;
    private IDAOFactory factory;

    public ExperimentManager(String experimentName, IDAOFactory factory) {
        this.factory = factory;
        this.experiment = this.getExperiment(experimentName);
        this.run = this.experiment.addExperimentRun("Run " + new Date().toString());
    }

    private Experiment getExperiment(String experimentName) {
        IExperimentDAO expDAO = this.factory.createExperimentDAO();
        Collection<Experiment> experimentColl = expDAO.findByExperimentName(experimentName);
        if (experimentColl.size() > 0) {
            return experimentColl.iterator().next();
        }
        return expDAO.addExperiment(experimentName);
    }

    public void storeTimeSpan(String sensorName, long startTime, long stopTime) {
        double time = (double)(stopTime - startTime) / 1000000.0;
        if (sensorName.equals("ServiceTime") && time < 0.5) {
            System.out.println("Time: " + time);
            System.out.println("startTime: " + startTime);
            System.out.println("stopTime: " + stopTime);
        }
        TimeSpanSensor sensor = this.getTimeSpanSensor(sensorName);
        this.run.addTimeSpanMeasurement(sensor, startTime, time);
    }

    public void storeTimeSpans(String sensorName, double[] durationArray, double[] timeArray, int upperBound) {
        TimeSpanSensor sensor = this.getTimeSpanSensor(sensorName);
        int i = 0;
        while (i < upperBound) {
            this.run.addTimeSpanMeasurement(sensor, timeArray[i], durationArray[i]);
            ++i;
        }
    }

    public void storeTimeSpans(String sensorName, List<Double> elements) {
        TimeSpanSensor sensor = this.getTimeSpanSensor(sensorName);
        int i = 0;
        for (Double d : elements) {
            this.run.addTimeSpanMeasurement(sensor, i, d);
            ++i;
        }
    }

    public void close() {
        this.factory.finalizeAndClose();
    }

    private TimeSpanSensor getTimeSpanSensor(String name) {
        TimeSpanSensor result = this.timeSpanSensorHash.get(name);
        if (result == null) {
            for (Sensor sensor : this.experiment.getSensors()) {
                if (!sensor.getSensorName().equals(name)) continue;
                result = (TimeSpanSensor)sensor;
                break;
            }
            if (result == null) {
                result = this.experiment.addTimeSpanSensor(name);
            }
            this.timeSpanSensorHash.put(name, result);
        }
        return result;
    }

    public void finalizeAndClose() {
        this.factory.finalizeAndClose();
    }
}

