/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.entities.base;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.ScalabilitySensor;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="EXPERIMENT")
public abstract class AbstractExperiment
implements Experiment {
    protected transient IDAOFactory myDAOFactory = null;
    @Id
    @Column(name="EXPERIMENTID")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long m_experimentID;
    @Column(name="EXPERIMENTNAME")
    private String m_experimentName;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="Experiment_sensors", joinColumns={@JoinColumn(name="EXPERIMENT_ID")}, inverseJoinColumns={@JoinColumn(name="SENSOR_ID")})
    private Collection<Sensor> m_sensors = new ArrayList<Sensor>();
    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="Experiment_experimentRuns", joinColumns={@JoinColumn(name="EXPERIMENT_ID")}, inverseJoinColumns={@JoinColumn(name="EXPERIMENTRUN_ID")})
    private Collection<ExperimentRun> m_experimentRuns = new ArrayList<ExperimentRun>();

    public AbstractExperiment(IDAOFactory myFactory) {
        this.myDAOFactory = myFactory;
    }

    @Override
    public long getExperimentID() {
        return this.m_experimentID;
    }

    @Override
    public void setExperimentID(long value) {
        this.m_experimentID = value;
    }

    @Override
    public String getExperimentName() {
        return this.m_experimentName;
    }

    @Override
    public void setExperimentName(String value) {
        this.m_experimentName = value;
    }

    @Override
    public StateSensor addStateSensor(State p_initialstate, String p_sensorname) {
        StateSensor result = this.myDAOFactory.createSensorDAO().addStateSensor(p_initialstate, p_sensorname);
        this.m_sensors.add(result);
        return result;
    }

    @Override
    public TimeSpanSensor addTimeSpanSensor(String p_sensorname) {
        TimeSpanSensor result = this.myDAOFactory.createSensorDAO().addTimeSpanSensor(p_sensorname);
        this.m_sensors.add(result);
        return result;
    }

    @Override
    public ScalabilitySensor addScalabilitySensor(String p_sensorname) {
        ScalabilitySensor result = this.myDAOFactory.createSensorDAO().addScalabilitySensor(p_sensorname);
        this.m_sensors.add(result);
        return result;
    }

    @Override
    public void addSensor(Sensor value) {
        this.m_sensors.add(value);
    }

    @Override
    public Collection<Sensor> getSensors() {
        return this.m_sensors;
    }

    @Override
    public ExperimentRun addExperimentRun(String p_experimentdatetime) {
        ExperimentRun result = this.myDAOFactory.createExperimentRunDAO().addExperimentRun(p_experimentdatetime);
        this.m_experimentRuns.add(result);
        return result;
    }

    @Override
    public ExperimentRun addScalabilityExperimentRun(String p_experimentdatetime) {
        ExperimentRun result = this.myDAOFactory.createExperimentRunDAO().addScalabilityExperimentRun(p_experimentdatetime);
        this.m_experimentRuns.add(result);
        return result;
    }

    @Override
    public void addExperimentRun(ExperimentRun value) {
        this.m_experimentRuns.add(value);
    }

    @Override
    public Collection<ExperimentRun> getExperimentRuns() {
        return this.m_experimentRuns;
    }
}

