/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.file.test;

import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.util.ArrayList;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.BeforeClass;

public class FileFactoryTest {
    static IDAOFactory f;

    @BeforeClass
    public static void setUpBeforClass() {
        double d;
        f = SensorFrameworkDataset.singleton().getDataSourceByID(2L);
        Experiment e = f.createExperimentDAO().addExperiment("Test");
        ExperimentRun er1 = e.addExperimentRun("TestRun1");
        ExperimentRun er2 = e.addExperimentRun("TestRun2");
        TimeSpanSensor s1 = e.addTimeSpanSensor("ATimeSpanSensor1");
        TimeSpanSensor s2 = e.addTimeSpanSensor("ATimeSpanSensor2");
        double[] m1s1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[] m1s2 = new double[]{1.5, 2.5, 3.5, 4.5, 5.5};
        double[] m2s1 = new double[]{2.0, 2.0, 3.0, 1.0, 0.0, 7.4};
        double[] dArray = m1s1;
        int n = m1s1.length;
        int n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            er1.addTimeSpanMeasurement(s1, d, d);
            ++n2;
        }
        dArray = m1s2;
        n = m1s2.length;
        n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            er1.addTimeSpanMeasurement(s2, d, d);
            ++n2;
        }
        dArray = m2s1;
        n = m2s1.length;
        n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            er2.addTimeSpanMeasurement(s1, d, d);
            ++n2;
        }
        f.finalizeAndClose();
    }

    @org.junit.Test
    public void loadExperiment() {
        Experiment e1 = f.createExperimentDAO().get(0L);
        Experiment e2 = new ArrayList<Experiment>(f.createExperimentDAO().findByExperimentName("Test")).get(0);
        Assert.assertEquals((Object)"Test", (Object)e1.getExperimentName());
        Assert.assertEquals((long)0L, (long)e1.getExperimentID());
        Assert.assertEquals((long)2L, (long)e1.getSensors().size());
        Assert.assertEquals((long)2L, (long)e1.getExperimentRuns().size());
        Assert.assertEquals((Object)"ATimeSpanSensor1", (Object)((Sensor)((List)e1.getSensors()).get(0)).getSensorName());
        Assert.assertEquals((Object)"ATimeSpanSensor2", (Object)((Sensor)((List)e1.getSensors()).get(1)).getSensorName());
        Assert.assertEquals((Object)"TestRun1", (Object)((ExperimentRun)((List)e1.getExperimentRuns()).get(0)).getExperimentDateTime());
        Assert.assertEquals((Object)"TestRun2", (Object)((ExperimentRun)((List)e1.getExperimentRuns()).get(1)).getExperimentDateTime());
        Assert.assertEquals((Object)"Test", (Object)e2.getExperimentName());
        Assert.assertEquals((long)0L, (long)e2.getExperimentID());
        Assert.assertEquals((long)2L, (long)e2.getSensors().size());
        Assert.assertEquals((long)2L, (long)e2.getExperimentRuns().size());
        Assert.assertEquals((Object)"ATimeSpanSensor1", (Object)((Sensor)((List)e2.getSensors()).get(0)).getSensorName());
        Assert.assertEquals((Object)"ATimeSpanSensor2", (Object)((Sensor)((List)e2.getSensors()).get(1)).getSensorName());
        Assert.assertEquals((Object)"TestRun1", (Object)((ExperimentRun)((List)e2.getExperimentRuns()).get(0)).getExperimentDateTime());
        Assert.assertEquals((Object)"TestRun2", (Object)((ExperimentRun)((List)e2.getExperimentRuns()).get(1)).getExperimentDateTime());
    }

    @org.junit.Test
    public void loadMeasurements() {
        Experiment e1 = f.createExperimentDAO().get(0L);
        Sensor s1 = (Sensor)((List)e1.getSensors()).get(0);
        Sensor s2 = (Sensor)((List)e1.getSensors()).get(1);
        ExperimentRun r1 = (ExperimentRun)((List)e1.getExperimentRuns()).get(0);
        ExperimentRun r2 = (ExperimentRun)((List)e1.getExperimentRuns()).get(1);
        List m1s1 = (List)r1.getMeasurementsOfSensor(s1).getMeasurements();
        Assert.assertEquals((long)5L, (long)m1s1.size());
        double e = 1.0E-8;
        Assert.assertEquals((double)1.0, (double)((Measurement)m1s1.get(0)).getEventTime(), (double)e);
        Assert.assertEquals((double)2.0, (double)((Measurement)m1s1.get(1)).getEventTime(), (double)e);
        Assert.assertEquals((double)3.0, (double)((Measurement)m1s1.get(2)).getEventTime(), (double)e);
        Assert.assertEquals((double)4.0, (double)((Measurement)m1s1.get(3)).getEventTime(), (double)e);
        Assert.assertEquals((double)5.0, (double)((Measurement)m1s1.get(4)).getEventTime(), (double)e);
        List m1s2 = (List)r1.getMeasurementsOfSensor(s2).getMeasurements();
        Assert.assertEquals((long)5L, (long)m1s1.size());
        Assert.assertEquals((double)1.5, (double)((Measurement)m1s2.get(0)).getEventTime(), (double)e);
        Assert.assertEquals((double)2.5, (double)((Measurement)m1s2.get(1)).getEventTime(), (double)e);
        Assert.assertEquals((double)3.5, (double)((Measurement)m1s2.get(2)).getEventTime(), (double)e);
        Assert.assertEquals((double)4.5, (double)((Measurement)m1s2.get(3)).getEventTime(), (double)e);
        Assert.assertEquals((double)5.5, (double)((Measurement)m1s2.get(4)).getEventTime(), (double)e);
        List m2s1 = (List)r2.getMeasurementsOfSensor(s1).getMeasurements();
        Assert.assertEquals((long)6L, (long)m2s1.size());
        Assert.assertEquals((double)2.0, (double)((Measurement)m2s1.get(0)).getEventTime(), (double)e);
        Assert.assertEquals((double)2.0, (double)((Measurement)m2s1.get(1)).getEventTime(), (double)e);
        Assert.assertEquals((double)3.0, (double)((Measurement)m2s1.get(2)).getEventTime(), (double)e);
        Assert.assertEquals((double)1.0, (double)((Measurement)m2s1.get(3)).getEventTime(), (double)e);
        Assert.assertEquals((double)0.0, (double)((Measurement)m2s1.get(4)).getEventTime(), (double)e);
        Assert.assertEquals((double)7.4, (double)((Measurement)m2s1.get(5)).getEventTime(), (double)e);
    }

    @org.junit.Test
    public void addExperiment() {
        f = SensorFrameworkDataset.singleton().getDataSourceByID(2L);
        Experiment e2 = f.createExperimentDAO().addExperiment("Test2");
        Assert.assertEquals((long)2L, (long)f.createExperimentDAO().getExperiments().size());
        Assert.assertEquals((long)1L, (long)e2.getExperimentID());
        f.createExperimentDAO().removeExperiment(e2, false);
        Assert.assertEquals((long)1L, (long)f.createExperimentDAO().getExperiments().size());
        f.finalizeAndClose();
    }

    public static Test suite() {
        return new JUnit4TestAdapter(FileFactoryTest.class);
    }
}

