/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.file.entities;

import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import de.uka.ipd.sdq.sensorframework.storage.lists.ISerialiser;
import java.util.HashMap;

public class StateSerializer
implements ISerialiser<State> {
    HashMap<Long, State> hashMap = new HashMap();
    StateSensor mySensor = null;

    public StateSerializer(StateSensor stateSensor) {
        this.mySensor = stateSensor;
        this.initSensorStateHash();
    }

    private void initSensorStateHash() {
        this.hashMap.clear();
        for (State s : this.mySensor.getSensorStates()) {
            this.hashMap.put(s.getStateID(), s);
        }
    }

    public State[] deserialise(byte[] bytes) {
        this.initSensorStateHash();
        State[] states = new State[(int)((long)bytes.length / this.getElementLength())];
        int blockPos = 0;
        int j = 0;
        while (j < states.length) {
            long l = 0L;
            int i = 7;
            while (i >= 0) {
                l <<= 8;
                l |= (long)(bytes[blockPos + i] < 0 ? 256 + bytes[blockPos + i] : bytes[blockPos + i]);
                --i;
            }
            blockPos += 8;
            states[j] = this.hashMap.get(l);
            if (states[j] == null) {
                throw new RuntimeException("State could not be deserialized as it returned null values for state " + j + ".");
            }
            ++j;
        }
        return states;
    }

    public long getElementLength() {
        return 8L;
    }

    public byte[] serialise(Object[] objects, int count) {
        byte[] block = new byte[(int)((long)count * this.getElementLength())];
        int blockPos = 0;
        int j = 0;
        while (j < count) {
            long l = ((State)objects[j]).getStateID();
            int i = 0;
            while (i < 8) {
                block[blockPos++] = (byte)(l & 0xFFL);
                l >>= 8;
                ++i;
            }
            ++j;
        }
        return block;
    }
}

